/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.builder.fragments.term;

import java.util.List;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.EmptySqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.PrepareSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.term.AbstractTermFragmentBuilder;

public class InTermFragmentBuilder
extends AbstractTermFragmentBuilder {
    private String symbol;

    public InTermFragmentBuilder(String termType, String name, boolean isNot) {
        super(termType, name);
        this.symbol = isNot ? "not in(" : "in(";
    }

    @Override
    public SqlFragments createFragments(String columnFullName, RDBColumnMetadata column, Term term) {
        List<Object> value = this.convertList(column, term);
        if (value == null || value.isEmpty()) {
            return EmptySqlFragments.INSTANCE;
        }
        int len = value.size();
        PrepareSqlFragments fragments = PrepareSqlFragments.of();
        if (len > 500) {
            fragments.addSql("(");
        }
        fragments.addSql(columnFullName).addSql(this.symbol);
        int flag = 0;
        for (int i = 0; i < len; ++i) {
            if (flag++ != 0) {
                fragments.addSql(",");
            }
            fragments.addSql("?");
            if (flag <= 500 || i == len - 1) continue;
            flag = 0;
            fragments.addSql(") or").addSql(columnFullName).addSql(this.symbol);
        }
        if (len > 500) {
            fragments.addSql(")");
        }
        return fragments.addSql(")").addParameter(value);
    }
}

