/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.codec;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hswebframework.ezorm.core.ValueCodec;

public class EnumValueCodec
implements ValueCodec<Object, Object> {
    private Class type;
    private boolean isArray;
    private boolean toMask;
    private Collector collector = Collectors.joining(",");
    private Function<String, String[]> splitter = str -> str.split("[,]");

    public EnumValueCodec(Class type) {
        if (type.isArray()) {
            this.type = type.getComponentType();
            this.isArray = true;
        } else {
            this.type = type;
        }
    }

    public EnumValueCodec(Class type, boolean toMask) {
        this(type);
        this.toMask = toMask;
    }

    public Object encode(Object value) {
        if (value instanceof Enum) {
            if (!this.toMask) {
                return ((Enum)value).name();
            }
            return this.enumToMask((Enum)value);
        }
        if (value instanceof Enum[]) {
            if (!this.toMask) {
                return Stream.of((Enum[])value).map(Enum::name).collect(this.collector);
            }
            return this.enumToMask((Enum[])value);
        }
        return value;
    }

    public Object decode(Object data) {
        if (data instanceof String) {
            if (!this.isArray) {
                return Stream.of(this.type.getEnumConstants()).map(Enum.class::cast).filter(e -> e.name().equalsIgnoreCase(String.valueOf(data))).findFirst().orElse(null);
            }
            List<Object> arr = Arrays.asList((Object[])this.splitter.apply((String)data));
            return Stream.of(this.type.getEnumConstants()).map(Enum.class::cast).filter(e -> arr.contains(e.name())).toArray(l -> (Enum[])Array.newInstance(this.type, l));
        }
        if (data instanceof Number) {
            long val = ((Number)data).longValue();
            Stream<Enum> stream = Stream.of(this.type.getEnumConstants()).map(Enum.class::cast).filter(e -> this.toMask ? this.enumInMask(val, (Enum)e) : (long)e.ordinal() == val);
            if (this.isArray) {
                return stream.toArray(l -> (Enum[])Array.newInstance(this.type, l));
            }
            return stream.findFirst().orElse(null);
        }
        return data;
    }

    private boolean enumInMask(long mask, Enum e) {
        return (mask & 1L << e.ordinal()) != 0L;
    }

    private long enumToMask(Enum ... enums) {
        if (enums == null) {
            return 0L;
        }
        long value = 0L;
        for (Enum e : enums) {
            value |= 1L << e.ordinal();
        }
        return value;
    }
}

