/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.mapping;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.hswebframework.ezorm.rdb.mapping.EntityColumnMapping;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.TableOrViewMetadata;

public class DefaultEntityColumnMapping
implements EntityColumnMapping {
    private final Map<String, String> propertyColumnMapping = new HashMap<String, String>();
    private final Map<String, String> columnPropertyMapping = new HashMap<String, String>();
    private final String id;
    private final String name;
    private final TableOrViewMetadata table;
    private final Class<?> entityType;

    public void addMapping(String column, String property) {
        this.columnPropertyMapping.put(column, property);
        this.propertyColumnMapping.put(property, column);
    }

    public DefaultEntityColumnMapping(TableOrViewMetadata table, Class<?> entityType) {
        this.id = this.getType().createFeatureId(entityType);
        this.name = this.getType().getName() + ":" + entityType.getSimpleName();
        this.table = table;
        this.entityType = entityType;
    }

    @Override
    public Optional<RDBColumnMetadata> getColumnByProperty(String property) {
        if (property.contains(".")) {
            String[] key = property.split("[.]");
            return this.table.getForeignKey(key[0]).flatMap(keyMetadata -> keyMetadata.getTarget().getColumn(key[1]));
        }
        return Optional.ofNullable(this.propertyColumnMapping.get(property)).flatMap(this.table::getColumn);
    }

    @Override
    public Optional<String> getPropertyByColumnName(String columnName) {
        return Optional.ofNullable(this.columnPropertyMapping.get(columnName));
    }

    @Override
    public Optional<RDBColumnMetadata> getColumnByName(String columnName) {
        if (columnName.contains(".")) {
            String[] key = columnName.split("[.]");
            return this.table.getForeignKey(key[0]).flatMap(keyMetadata -> keyMetadata.getTarget().getColumn(key[1]));
        }
        return this.table.getColumn(columnName);
    }

    @Override
    public Map<String, String> getColumnPropertyMapping() {
        return new HashMap<String, String>(this.columnPropertyMapping);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public TableOrViewMetadata getTable() {
        return this.table;
    }

    @Override
    public Class<?> getEntityType() {
        return this.entityType;
    }
}

