/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.mapping.defaults;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.hswebframework.ezorm.core.MethodReferenceColumn;
import org.hswebframework.ezorm.core.NestConditional;
import org.hswebframework.ezorm.core.SimpleNestConditional;
import org.hswebframework.ezorm.core.StaticMethodReferenceColumn;
import org.hswebframework.ezorm.core.TermTypeConditionalSupport;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.events.ContextKeyValue;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrapper;
import org.hswebframework.ezorm.rdb.mapping.DSLQuery;
import org.hswebframework.ezorm.rdb.mapping.EntityColumnMapping;
import org.hswebframework.ezorm.rdb.metadata.TableOrViewMetadata;
import org.hswebframework.ezorm.rdb.operator.DMLOperator;
import org.hswebframework.ezorm.rdb.operator.dml.SortOrderSupplier;
import org.hswebframework.ezorm.rdb.operator.dml.query.SelectColumn;
import org.hswebframework.ezorm.rdb.operator.dml.query.SortOrder;

public class DefaultQuery<T, ME extends DSLQuery>
implements DSLQuery<ME> {
    protected QueryParam param = new QueryParam();
    protected Term.Type currentTermType = Term.Type.and;
    protected TermTypeConditionalSupport.Accepter<ME, Object> accepter = (string, string2, object) -> this.and(string, string2, object);
    protected DMLOperator operator;
    protected ResultWrapper<T, ?> wrapper;
    protected TableOrViewMetadata tableMetadata;
    protected EntityColumnMapping columnMapping;
    protected List<SortOrder> orders = new ArrayList<SortOrder>();

    public DefaultQuery(TableOrViewMetadata tableMetadata, EntityColumnMapping mapping, DMLOperator operator, ResultWrapper<T, ?> wrapper, ContextKeyValue<?> ... keyValues) {
        this.operator = operator;
        this.wrapper = wrapper;
        this.tableMetadata = tableMetadata;
        this.columnMapping = mapping;
        this.param.setPaging(false);
    }

    @Override
    public ME select(String ... columns) {
        this.param.includes(columns);
        return (ME)this;
    }

    @Override
    @SafeVarargs
    public final <T> ME select(StaticMethodReferenceColumn<T> ... column) {
        return this.select((String[])Arrays.stream(column).map(StaticMethodReferenceColumn::getColumn).toArray(String[]::new));
    }

    @Override
    @SafeVarargs
    public final <T> ME select(MethodReferenceColumn<T> ... column) {
        return this.select((String[])Arrays.stream(column).map(MethodReferenceColumn::getColumn).toArray(String[]::new));
    }

    @Override
    @SafeVarargs
    public final <T> ME selectExcludes(StaticMethodReferenceColumn<T> ... column) {
        return this.selectExcludes((String[])Arrays.stream(column).map(StaticMethodReferenceColumn::getColumn).toArray(String[]::new));
    }

    @Override
    @SafeVarargs
    public final <T> ME selectExcludes(MethodReferenceColumn<T> ... column) {
        return this.selectExcludes((String[])Arrays.stream(column).map(MethodReferenceColumn::getColumn).toArray(String[]::new));
    }

    @Override
    public ME selectExcludes(String ... columns) {
        this.param.excludes(columns);
        return (ME)this;
    }

    @Override
    public ME paging(int pageIndex, int pageSize) {
        this.param.doPaging(pageIndex, pageSize);
        return (ME)this;
    }

    @Override
    public ME orderBy(SortOrder ... orders) {
        this.orders.addAll(Arrays.asList(orders));
        return (ME)this;
    }

    @Override
    public ME orderBy(SortOrderSupplier ... orders) {
        return this.orderBy((SortOrder[])Arrays.stream(orders).map(Supplier::get).toArray(SortOrder[]::new));
    }

    @Override
    public ME setParam(QueryParam param) {
        this.param = param;
        return (ME)this;
    }

    private boolean isSelectInclude(SelectColumn column) {
        return this.param.getIncludes().isEmpty() || this.param.getIncludes().stream().anyMatch(s -> s.equals(column.getColumn()) || s.equals(column.getAlias()));
    }

    private boolean isSelectExclude(SelectColumn column) {
        return this.param.getExcludes().stream().anyMatch(s -> s.equals(column.getColumn()) || s.equals(column.getAlias()));
    }

    protected SelectColumn[] getSelectColumn() {
        return (SelectColumn[])Stream.concat(this.tableMetadata.getForeignKeys().stream().map(key -> key.getAlias() == null ? key.getTarget().getName() : key.getAlias()).map(alias -> alias.concat(".*")).map(name -> SelectColumn.of(name)), this.columnMapping.getColumnPropertyMapping().entrySet().stream().map(entry -> SelectColumn.of((String)entry.getKey(), (String)entry.getValue()))).filter(this::isSelectInclude).filter(e -> !this.isSelectExclude((SelectColumn)e)).toArray(SelectColumn[]::new);
    }

    protected SortOrder[] getSortOrder() {
        return (SortOrder[])Stream.concat(this.param.getSorts().stream().map(sort -> sort.getOrder().equalsIgnoreCase("asc") ? SortOrder.asc(sort.getName()) : SortOrder.desc(sort.getName())), this.orders.stream()).toArray(SortOrder[]::new);
    }

    public NestConditional<ME> nest() {
        return new SimpleNestConditional((TermTypeConditionalSupport)this, this.param.nest());
    }

    public NestConditional<ME> orNest() {
        return new SimpleNestConditional((TermTypeConditionalSupport)this, this.param.orNest());
    }

    public ME and() {
        this.accepter = (string, string2, object) -> this.and(string, string2, object);
        this.currentTermType = Term.Type.and;
        return (ME)this;
    }

    public ME or() {
        this.accepter = (string, string2, object) -> this.or(string, string2, object);
        this.currentTermType = Term.Type.or;
        return (ME)this;
    }

    public ME and(String column, String termType, Object value) {
        if (value != null) {
            this.param.and(column, termType, value);
        }
        return (ME)this;
    }

    public ME or(String column, String termType, Object value) {
        if (value != null) {
            this.param.or(column, termType, value);
        }
        return (ME)this;
    }

    public TermTypeConditionalSupport.Accepter<ME, Object> getAccepter() {
        return this.accepter;
    }

    public ME accept(Term term) {
        this.param.getTerms().add(term);
        return (ME)this;
    }
}

