/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.supports.mssql;

import org.hswebframework.ezorm.core.DefaultValue;
import org.hswebframework.ezorm.rdb.executor.DefaultBatchSqlRequest;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBIndexMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.NativeSql;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.PrepareSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.ddl.CreateIndexParameter;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.ddl.CreateIndexSqlBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.ddl.CreateTableSqlBuilder;
import org.hswebframework.ezorm.rdb.supports.mssql.SqlServerCommentUtils;

public class SqlServerCreateTableSqlBuilder
implements CreateTableSqlBuilder {
    private boolean createComment = true;

    @Override
    public SqlRequest build(RDBTableMetadata table) {
        DefaultBatchSqlRequest sql = new DefaultBatchSqlRequest();
        PrepareSqlFragments createTable = PrepareSqlFragments.of();
        createTable.addSql("create table", table.getFullName(), "(");
        int index = 0;
        for (RDBColumnMetadata column : table.getColumns()) {
            if (index++ != 0) {
                createTable.addSql(",");
            }
            createTable.addSql(column.getQuoteName());
            if (column.getColumnDefinition() != null) {
                createTable.addSql(column.getColumnDefinition());
            } else {
                DefaultValue defaultValue;
                createTable.addSql(column.getDialect().buildColumnDataType(column));
                if (column.isNotNull() || column.isPrimaryKey()) {
                    createTable.addSql("not null");
                }
                if (column.isPrimaryKey()) {
                    createTable.addSql("primary key");
                }
                if ((defaultValue = column.getDefaultValue()) instanceof NativeSql) {
                    createTable.addSql("default", ((NativeSql)defaultValue).getSql());
                }
            }
            if (!this.createComment || column.getComment() == null) continue;
            sql.addBatch(SqlServerCommentUtils.createDropAdnCreateColumnComment(table, column).toRequest());
        }
        createTable.addSql(")");
        if (this.createComment && table.getComment() != null) {
            sql.addBatch(SqlServerCommentUtils.createDropAndCreateTableCommentSql(table).toRequest());
        }
        table.findFeature(CreateIndexSqlBuilder.ID).ifPresent(builder -> {
            for (RDBIndexMetadata tableIndex : table.getIndexes()) {
                sql.addBatch(builder.build(CreateIndexParameter.of(table, tableIndex)));
            }
        });
        sql.setSql(createTable.toRequest().getSql());
        return sql;
    }

    public boolean isCreateComment() {
        return this.createComment;
    }

    public void setCreateComment(boolean createComment) {
        this.createComment = createComment;
    }
}

