/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.codec;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.function.Function;
import org.hswebframework.ezorm.core.ValueCodec;
import org.hswebframework.ezorm.rdb.executor.NullValue;
import org.hswebframework.utils.ClassUtils;
import org.hswebframework.utils.StringUtils;
import org.hswebframework.utils.time.DateFormatter;

public class NumberValueCodec
implements ValueCodec {
    private final Function<Number, Object> converter;

    public NumberValueCodec(Function<Number, Object> converter) {
        this.converter = converter;
    }

    public NumberValueCodec(Class javaType) {
        this.converter = javaType == Integer.TYPE || javaType == Integer.class ? Number::intValue : (javaType == Double.TYPE || javaType == Double.class ? Number::doubleValue : (javaType == Float.TYPE || javaType == Float.class ? Number::floatValue : (javaType == Long.TYPE || javaType == Long.class ? Number::longValue : (javaType == Byte.TYPE || javaType == Byte.class ? Number::byteValue : (javaType == Short.TYPE || javaType == Short.class ? Number::shortValue : (javaType == Boolean.TYPE || javaType == Boolean.class ? num -> num.byteValue() != 0 : (ClassUtils.instanceOf((Class)javaType, Date.class) ? num -> {
            try {
                Date date = (Date)javaType.newInstance();
                date.setTime(num.longValue());
                return date;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } : num -> num)))))));
    }

    private Object tryCastNumber(Object value) {
        if (null == value) {
            return null;
        }
        if (value instanceof NullValue) {
            return value;
        }
        if (value instanceof Date) {
            value = ((Date)value).getTime();
        } else if (value instanceof LocalDateTime) {
            value = ((LocalDateTime)value).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        } else if (value instanceof String) {
            Date date = DateFormatter.fromString((String)String.valueOf(value));
            value = null != date ? Long.valueOf(date.getTime()) : new BigDecimal(String.valueOf(value));
        }
        if (value instanceof Number) {
            return this.converter.apply((Number)value);
        }
        if (Boolean.TRUE.equals(value)) {
            return this.converter.apply(1);
        }
        if (Boolean.FALSE.equals(value)) {
            return this.converter.apply(0);
        }
        throw new IllegalArgumentException("\u503c" + value + "\u65e0\u6cd5\u8f6c\u6362\u4e3a\u6570\u5b57");
    }

    public Object encode(Object value) {
        if (StringUtils.isNullOrEmpty((Object)value)) {
            return null;
        }
        return this.tryCastNumber(value);
    }

    public Object decode(Object data) {
        return this.tryCastNumber(data);
    }
}

