/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.supports.h2;

import java.sql.JDBCType;
import org.hswebframework.ezorm.rdb.metadata.DataType;
import org.hswebframework.ezorm.rdb.metadata.JdbcDataType;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.dialect.DefaultDialect;
import org.hswebframework.utils.StringUtils;

public class H2Dialect
extends DefaultDialect {
    public H2Dialect() {
        this.addDataTypeBuilder(JDBCType.VARCHAR, (RDBColumnMetadata meta) -> StringUtils.concat((Object[])new Object[]{"varchar(", meta.getLength(), ")"}));
        this.addDataTypeBuilder(JDBCType.TIMESTAMP, (RDBColumnMetadata meta) -> "timestamp");
        this.addDataTypeBuilder(JDBCType.SMALLINT, (RDBColumnMetadata meta) -> "smallint");
        this.addDataTypeBuilder(JDBCType.BIGINT, (RDBColumnMetadata meta) -> "bigint");
        this.addDataTypeBuilder(JDBCType.TIME, (RDBColumnMetadata meta) -> "timestamp");
        this.addDataTypeBuilder(JDBCType.DATE, (RDBColumnMetadata meta) -> "date");
        this.addDataTypeBuilder(JDBCType.CLOB, (RDBColumnMetadata meta) -> "clob");
        this.addDataTypeBuilder(JDBCType.BLOB, (RDBColumnMetadata meta) -> "blob");
        this.addDataTypeBuilder(JDBCType.INTEGER, (RDBColumnMetadata meta) -> "int");
        this.addDataTypeBuilder(JDBCType.NUMERIC, (RDBColumnMetadata meta) -> StringUtils.concat((Object[])new Object[]{"decimal(", meta.getPrecision(32), ",", meta.getScale(), ")"}));
        this.addDataTypeBuilder(JDBCType.TINYINT, (RDBColumnMetadata meta) -> "tinyint");
        this.addDataTypeBuilder(JDBCType.DECIMAL, (RDBColumnMetadata meta) -> StringUtils.concat((Object[])new Object[]{"decimal(", meta.getPrecision(32), ",", meta.getScale(), ")"}));
        this.addDataTypeBuilder(JDBCType.OTHER, (RDBColumnMetadata meta) -> "other");
        this.registerDataType("longnvarchar", DataType.builder(JdbcDataType.of(JDBCType.LONGNVARCHAR, String.class), c -> "clob"));
        this.registerDataType("longvarchar", DataType.builder(JdbcDataType.of(JDBCType.LONGVARCHAR, String.class), c -> "clob"));
        this.addDataTypeBuilder(JDBCType.LONGNVARCHAR, (RDBColumnMetadata meta) -> "clob");
        this.addDataTypeBuilder(JDBCType.LONGVARBINARY, (RDBColumnMetadata meta) -> "blob");
        this.registerDataType("character varying", DataType.builder(JdbcDataType.of(JDBCType.VARCHAR, String.class), column -> "varchar(" + column.getLength() + ")"));
    }

    @Override
    public String getQuoteStart() {
        return "\"";
    }

    @Override
    public String getQuoteEnd() {
        return "\"";
    }

    @Override
    public boolean isColumnToUpperCase() {
        return true;
    }

    public String getId() {
        return "h2database";
    }

    public String getName() {
        return "H2";
    }
}

