/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.mapping.defaults;

import java.util.Collection;
import java.util.function.Supplier;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.ezorm.rdb.events.ContextKeyValue;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrapper;
import org.hswebframework.ezorm.rdb.mapping.ReactiveDelete;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.ReactiveRepository;
import org.hswebframework.ezorm.rdb.mapping.ReactiveUpdate;
import org.hswebframework.ezorm.rdb.mapping.defaults.DefaultReactiveDelete;
import org.hswebframework.ezorm.rdb.mapping.defaults.DefaultReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.defaults.DefaultReactiveUpdate;
import org.hswebframework.ezorm.rdb.mapping.defaults.DefaultRepository;
import org.hswebframework.ezorm.rdb.mapping.defaults.SaveResult;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.metadata.TableOrViewMetadata;
import org.hswebframework.ezorm.rdb.operator.DatabaseOperator;
import org.hswebframework.ezorm.rdb.operator.dml.QueryOperator;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultReactiveRepository<E, K>
extends DefaultRepository<E>
implements ReactiveRepository<E, K> {
    private final Logger logger;

    public DefaultReactiveRepository(DatabaseOperator operator, String table, Class<E> type, ResultWrapper<E, ?> wrapper) {
        this(operator, () -> operator.getMetadata().getTable(table).orElseThrow(() -> new UnsupportedOperationException("table [" + table + "] doesn't exist")), type, wrapper);
    }

    public DefaultReactiveRepository(DatabaseOperator operator, RDBTableMetadata table, Class<E> type, ResultWrapper<E, ?> wrapper) {
        this(operator, () -> table, type, wrapper);
    }

    public DefaultReactiveRepository(DatabaseOperator operator, Supplier<RDBTableMetadata> table, Class<E> type, ResultWrapper<E, ?> wrapper) {
        super(operator, table, wrapper);
        this.initMapping(type);
        this.logger = DefaultReactiveRepository.getLogger(type);
    }

    private static Logger getLogger(Class<?> type) {
        return LoggerFactory.getLogger(type);
    }

    @Override
    public Mono<E> newInstance() {
        return Mono.fromSupplier(this.wrapper::newRowInstance);
    }

    @Override
    public Mono<E> findById(Mono<K> primaryKey) {
        return primaryKey.flatMap(k -> ((ReactiveQuery)this.createQuery().where(this.getIdColumn(), k)).fetchOne());
    }

    @Override
    public Flux<E> findById(Flux<K> key) {
        return key.collectList().filter(CollectionUtils::isNotEmpty).flatMapMany(idList -> ((ReactiveQuery)((ReactiveQuery)this.createQuery().where()).in(this.getIdColumn(), (Collection)idList)).fetch());
    }

    @Override
    public Mono<Integer> deleteById(Publisher<K> key) {
        return Flux.from(key).collectList().filter(CollectionUtils::isNotEmpty).flatMap(list -> ((ReactiveDelete)((ReactiveDelete)this.createDelete().where()).in(this.getIdColumn(), (Collection)list)).execute()).defaultIfEmpty((Object)0);
    }

    @Override
    public Mono<Integer> updateById(K id, Mono<E> data) {
        return data.flatMap(_data -> ((ReactiveUpdate)((ReactiveUpdate)this.createUpdate().where(this.getIdColumn(), id)).set(_data)).execute());
    }

    @Override
    public Mono<SaveResult> save(Publisher<E> data) {
        return Flux.from(data).collectList().filter(CollectionUtils::isNotEmpty).flatMap(list -> (Mono)this.doSave(list).reactive().as(this::setupLogger)).defaultIfEmpty((Object)SaveResult.of(0, 0));
    }

    @Override
    public Mono<Integer> insert(Publisher<E> data) {
        return Flux.from(data).flatMap(e -> (Mono)this.doInsert(e).reactive().as(this::setupLogger)).reduce(Math::addExact).defaultIfEmpty((Object)0);
    }

    @Override
    public Mono<Integer> insertBatch(Publisher<? extends Collection<E>> data) {
        return (Mono)Flux.from(data).filter(CollectionUtils::isNotEmpty).flatMap(e -> this.doInsert(e).reactive()).reduce(Math::addExact).defaultIfEmpty((Object)0).as(this::setupLogger);
    }

    @Override
    public ReactiveQuery<E> createQuery() {
        return new DefaultReactiveQuery((TableOrViewMetadata)this.getTable(), this.mapping, this.operator.dml(), this.wrapper, this.logger, this.getDefaultContextKeyValue(new ContextKeyValue[0]));
    }

    @Override
    public ReactiveUpdate<E> createUpdate() {
        return new DefaultReactiveUpdate(this.getTable(), this.operator.dml().update(this.getTable().getFullName()), this.mapping, this.logger, this.getDefaultContextKeyValue(new ContextKeyValue[0]));
    }

    @Override
    public ReactiveDelete createDelete() {
        return new DefaultReactiveDelete(this.getTable(), this.operator.dml().delete(this.getTable().getFullName()), this.logger, this.getDefaultContextKeyValue(new ContextKeyValue[0]));
    }

    private <T> Mono<T> setupLogger(Mono<T> async) {
        return async.contextWrite(ctx -> ctx.put(Logger.class, (Object)this.logger));
    }

    private <T> Flux<T> setupLogger(Flux<T> async) {
        return async.contextWrite(ctx -> ctx.put(Logger.class, (Object)this.logger));
    }

    @Override
    public QueryOperator nativeQuery() {
        return this.operator.dml().query(this.getTable());
    }
}

