/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.mapping.jpa;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.Set;
import org.hswebframework.ezorm.rdb.mapping.EntityPropertyDescriptor;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.utils.AnnotationUtils;
import org.hswebframework.ezorm.rdb.utils.PropertiesUtils;

public class SimpleEntityPropertyDescriptor
implements EntityPropertyDescriptor {
    private Class entityType;
    private String propertyName;
    private Class propertyType;
    private RDBColumnMetadata column;
    private PropertyDescriptor descriptor;

    public static EntityPropertyDescriptor of(PropertyDescriptor descriptor, RDBColumnMetadata column) {
        return SimpleEntityPropertyDescriptor.of(descriptor.getReadMethod().getDeclaringClass(), descriptor.getName(), descriptor.getPropertyType(), column, descriptor);
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public Field getField() {
        return PropertiesUtils.getPropertyField(this.entityType, this.descriptor.getName()).orElseThrow(() -> new NoSuchFieldException("no such field " + this.propertyName + " in " + this.entityType));
    }

    @Override
    public Class getPropertyType() {
        return this.propertyType;
    }

    @Override
    public RDBColumnMetadata getColumn() {
        return this.column;
    }

    @Override
    public <T extends Annotation> Optional<T> findAnnotation(Class<T> tClass) {
        return Optional.ofNullable(AnnotationUtils.getAnnotation(this.entityType, this.descriptor, tClass));
    }

    @Override
    public Set<Annotation> getAnnotations() {
        return AnnotationUtils.getAnnotations(this.entityType, this.descriptor);
    }

    private SimpleEntityPropertyDescriptor(Class entityType, String propertyName, Class propertyType, RDBColumnMetadata column, PropertyDescriptor descriptor) {
        this.entityType = entityType;
        this.propertyName = propertyName;
        this.propertyType = propertyType;
        this.column = column;
        this.descriptor = descriptor;
    }

    public static SimpleEntityPropertyDescriptor of(Class entityType, String propertyName, Class propertyType, RDBColumnMetadata column, PropertyDescriptor descriptor) {
        return new SimpleEntityPropertyDescriptor(entityType, propertyName, propertyType, column, descriptor);
    }
}

