/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.supports.mysql;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hswebframework.ezorm.rdb.codec.JdbcResultDecoder;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.executor.SqlRequests;
import org.hswebframework.ezorm.rdb.executor.SyncSqlExecutor;
import org.hswebframework.ezorm.rdb.executor.reactive.ReactiveSqlExecutor;
import org.hswebframework.ezorm.rdb.executor.wrapper.ColumnWrapperContext;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrapper;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrappers;
import org.hswebframework.ezorm.rdb.metadata.RDBIndexMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBSchemaMetadata;
import org.hswebframework.ezorm.rdb.metadata.parser.IndexMetadataParser;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MysqlIndexMetadataParser
implements IndexMetadataParser {
    private static final Logger log = LoggerFactory.getLogger(MysqlIndexMetadataParser.class);
    private final RDBSchemaMetadata schema;
    static String selectIndexSql = String.join((CharSequence)" ", "SELECT", "*", "FROM", "INFORMATION_SCHEMA.STATISTICS", "WHERE", "TABLE_SCHEMA = ? and TABLE_NAME like ?");
    static String selectIndexSqlByName = String.join((CharSequence)" ", "SELECT", "*", "FROM", "INFORMATION_SCHEMA.STATISTICS", "WHERE", "TABLE_SCHEMA = ? and INDEX_NAME=?");

    @Override
    public List<RDBIndexMetadata> parseTableIndex(String tableName) {
        return ((SyncSqlExecutor)this.schema.findFeatureNow(SyncSqlExecutor.ID)).select(SqlRequests.of(selectIndexSql, this.schema.getName(), tableName), ResultWrappers.lowerCase(new MysqlIndexWrapper()));
    }

    public Optional<RDBIndexMetadata> parseByName(String name) {
        return ((SyncSqlExecutor)this.schema.findFeatureNow(SyncSqlExecutor.ID)).select(SqlRequests.of(selectIndexSqlByName, this.schema.getName(), name), new MysqlIndexWrapper()).stream().findAny();
    }

    @Override
    public List<RDBIndexMetadata> parseAll() {
        return ((SyncSqlExecutor)this.schema.findFeatureNow(SyncSqlExecutor.ID)).select(SqlRequests.of(selectIndexSql, this.schema.getName(), "%%"), ResultWrappers.lowerCase(new MysqlIndexWrapper()));
    }

    @Override
    public Flux<RDBIndexMetadata> parseAllReactive() {
        return this.doSelectReactive(SqlRequests.of(selectIndexSql, this.schema.getName(), "%%"));
    }

    protected Flux<RDBIndexMetadata> doSelectReactive(SqlRequest sqlRequest) {
        MysqlIndexWrapper wrapper = new MysqlIndexWrapper();
        return ((ReactiveSqlExecutor)this.schema.findFeatureNow(ReactiveSqlExecutor.ID)).select(sqlRequest, ResultWrappers.lowerCase(wrapper)).thenMany((Publisher)Flux.defer(() -> Flux.fromIterable((Iterable)wrapper.getResult())));
    }

    public Mono<RDBIndexMetadata> parseByNameReactive(String name) {
        return this.doSelectReactive(SqlRequests.of(selectIndexSqlByName, this.schema.getName(), name)).singleOrEmpty();
    }

    @Override
    public Flux<RDBIndexMetadata> parseTableIndexReactive(String tableName) {
        return this.doSelectReactive(SqlRequests.of(selectIndexSql, this.schema.getName(), tableName));
    }

    public MysqlIndexMetadataParser(RDBSchemaMetadata schema) {
        this.schema = schema;
    }

    public RDBSchemaMetadata getSchema() {
        return this.schema;
    }

    static class MysqlIndexWrapper
    implements ResultWrapper<Map<String, String>, List<RDBIndexMetadata>> {
        Map<String, RDBIndexMetadata> groupByName = new HashMap<String, RDBIndexMetadata>();

        MysqlIndexWrapper() {
        }

        @Override
        public Map<String, String> newRowInstance() {
            return new HashMap<String, String>();
        }

        @Override
        public void wrapColumn(ColumnWrapperContext<Map<String, String>> context) {
            if (context.getResult() != null) {
                context.getRowInstance().put(context.getColumnLabel().toLowerCase(), String.valueOf(JdbcResultDecoder.INSTANCE.decode(context.getResult())));
            }
        }

        @Override
        public boolean completedWrapRow(Map<String, String> result) {
            String name = result.get("index_name");
            RDBIndexMetadata index = this.groupByName.computeIfAbsent(name, __ -> new RDBIndexMetadata());
            index.setName(result.get("index_name"));
            index.setUnique("0".equals(result.get("non_unique")));
            index.setTableName(result.get("table_name"));
            index.setPrimaryKey("PRIMARY".equalsIgnoreCase(name));
            RDBIndexMetadata.IndexColumn column = new RDBIndexMetadata.IndexColumn();
            column.setColumn(result.get("column_name"));
            column.setSortIndex(Integer.parseInt(result.get("seq_in_index")));
            column.setSort(RDBIndexMetadata.IndexSort.asc);
            index.getColumns().add(column);
            return true;
        }

        @Override
        public List<RDBIndexMetadata> getResult() {
            return new LinkedList<RDBIndexMetadata>(this.groupByName.values());
        }
    }
}

