/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.executor.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.List;
import org.hswebframework.ezorm.rdb.executor.BatchSqlRequest;
import org.hswebframework.ezorm.rdb.executor.DefaultColumnWrapperContext;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.executor.jdbc.JdbcSqlExecutorHelper;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrapper;
import org.hswebframework.ezorm.rdb.utils.SqlUtils;
import org.slf4j.Logger;
import reactor.core.Disposable;
import reactor.core.Disposables;

public abstract class JdbcSqlExecutor {
    private Logger logger;

    protected void releaseStatement(Statement statement) {
        statement.close();
    }

    protected void releaseResultSet(ResultSet resultSet) {
        resultSet.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doUpdate(Logger logger, Connection connection, SqlRequest request) {
        SqlUtils.printSql(logger, request);
        PreparedStatement statement = null;
        try {
            int count = 0;
            if (!request.isEmpty()) {
                statement = connection.prepareStatement(request.getSql());
                JdbcSqlExecutorHelper.preparedStatementParameter(statement, request.getParameters());
                logger.debug("==>    Updated: {}", (Object)(count += statement.executeUpdate()));
            }
            if (request instanceof BatchSqlRequest) {
                for (SqlRequest batch : ((BatchSqlRequest)request).getBatch()) {
                    if (batch.isEmpty()) continue;
                    if (null != statement) {
                        this.releaseStatement(statement);
                    }
                    SqlUtils.printSql(logger, batch);
                    statement = connection.prepareStatement(batch.getSql());
                    JdbcSqlExecutorHelper.preparedStatementParameter(statement, batch.getParameters());
                    int rows = statement.executeUpdate();
                    count += rows;
                    logger.debug("==>    Updated: {}", (Object)rows);
                }
            }
            int n = count;
            if (null != statement) {
                this.releaseStatement(statement);
            }
            return n;
        }
        catch (Throwable throwable) {
            if (null != statement) {
                this.releaseStatement(statement);
            }
            throw throwable;
        }
    }

    protected int doUpdate(Connection connection, SqlRequest request) {
        return this.doUpdate(this.logger, connection, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(Logger logger, Connection connection, SqlRequest request) {
        PreparedStatement statement = null;
        try {
            if (!request.isEmpty()) {
                SqlUtils.printSql(logger, request);
                statement = connection.prepareStatement(request.getSql());
                JdbcSqlExecutorHelper.preparedStatementParameter(statement, request.getParameters());
                statement.execute();
            }
            if (request instanceof BatchSqlRequest) {
                for (SqlRequest batch : ((BatchSqlRequest)request).getBatch()) {
                    if (batch.isEmpty()) continue;
                    if (null != statement) {
                        this.releaseStatement(statement);
                    }
                    SqlUtils.printSql(logger, batch);
                    statement = connection.prepareStatement(batch.getSql());
                    JdbcSqlExecutorHelper.preparedStatementParameter(statement, batch.getParameters());
                    statement.execute();
                }
            }
            if (null != statement) {
                this.releaseStatement(statement);
            }
        }
        catch (Throwable throwable) {
            if (null != statement) {
                this.releaseStatement(statement);
            }
            throw throwable;
        }
    }

    protected void doExecute(Connection connection, SqlRequest request) {
        this.doExecute(this.logger, connection, request);
    }

    protected Object getResultValue(ResultSetMetaData metaData, ResultSet set, int columnIndex) {
        switch (metaData.getColumnType(columnIndex)) {
            case 93: {
                return set.getTimestamp(columnIndex);
            }
            case 92: {
                return set.getTime(columnIndex);
            }
            case -1: 
            case 12: {
                return set.getString(columnIndex);
            }
            case 91: {
                return set.getDate(columnIndex);
            }
            case 2005: {
                return set.getClob(columnIndex);
            }
            case 2004: {
                return set.getBlob(columnIndex);
            }
        }
        return set.getObject(columnIndex);
    }

    protected PreparedStatement createStatement(Connection connection, String sql) {
        return connection.prepareStatement(sql);
    }

    protected ResultSet beforeRead(ResultSet resultSet) {
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T, R> R doSelect(Logger logger, Connection connection, SqlRequest request, ResultWrapper<T, R> wrapper, Disposable.Composite stopped) {
        PreparedStatement statement = this.createStatement(connection, request.getSql());
        try {
            SqlUtils.printSql(logger, request);
            Disposable disposable = () -> {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("==>    Cancel: {}", (Object)request.toNativeSql());
                    }
                    this.releaseStatement(statement);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            };
            stopped.add(disposable);
            if (stopped.isDisposed()) {
                R r = wrapper.getResult();
                return r;
            }
            JdbcSqlExecutorHelper.preparedStatementParameter(statement, request.getParameters());
            ResultSet resultSet = this.beforeRead(statement.executeQuery());
            ResultSetMetaData metaData = resultSet.getMetaData();
            List<String> columns = JdbcSqlExecutorHelper.getResultColumns(metaData);
            wrapper.beforeWrap(() -> columns);
            int index = 0;
            stopped.remove(disposable);
            while (resultSet.next()) {
                T data = wrapper.newRowInstance();
                for (int i = 0; i < columns.size(); ++i) {
                    String column = columns.get(i);
                    Object value = this.getResultValue(metaData, resultSet, i + 1);
                    DefaultColumnWrapperContext<T> context = new DefaultColumnWrapperContext<T>(i, column, value, data);
                    wrapper.wrapColumn(context);
                    data = context.getRowInstance();
                }
                ++index;
                if (wrapper.completedWrapRow(data) && !stopped.isDisposed()) continue;
            }
            wrapper.completedWrap();
            logger.debug("==>    Results: {}", (Object)index);
            this.releaseResultSet(resultSet);
            R r = wrapper.getResult();
            return r;
        }
        finally {
            this.releaseStatement(statement);
        }
    }

    public <T, R> R doSelect(Connection connection, SqlRequest request, ResultWrapper<T, R> wrapper) {
        return this.doSelect(this.logger, connection, request, wrapper, Disposables.composite());
    }

    public JdbcSqlExecutor(Logger logger) {
        this.logger = logger;
    }
}

