/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.builder;

import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBFeatureType;
import org.hswebframework.ezorm.rdb.metadata.RDBFeatures;
import org.hswebframework.ezorm.rdb.metadata.RDBSchemaMetadata;
import org.hswebframework.ezorm.rdb.metadata.TableOrViewMetadata;
import org.hswebframework.ezorm.rdb.operator.builder.FragmentBlock;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.BatchSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.BlockSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.NativeSql;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.PrepareSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.function.FunctionFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.query.QuerySqlBuilder;
import org.hswebframework.ezorm.rdb.operator.dml.query.QueryOperatorParameter;
import org.hswebframework.ezorm.rdb.operator.dml.query.SelectColumn;
import reactor.core.publisher.Mono;

public class DefaultQuerySqlBuilder
implements QuerySqlBuilder {
    protected RDBSchemaMetadata schema;
    protected static final SqlFragments SELECT = SqlFragments.single("select");
    protected static final SqlFragments WHERE = SqlFragments.single("where");
    protected static final SqlFragments GROUP_BY = SqlFragments.single("group by");
    protected static final SqlFragments ORDER_BY = SqlFragments.single("order by");
    protected static final SqlFragments FOR_UPDATE = SqlFragments.single("for update");

    protected DefaultQuerySqlBuilder(RDBSchemaMetadata schema) {
        this.schema = schema;
    }

    public static DefaultQuerySqlBuilder of(RDBSchemaMetadata schema) {
        return new DefaultQuerySqlBuilder(schema);
    }

    protected Optional<SqlFragments> select(QueryOperatorParameter parameter, TableOrViewMetadata metadata) {
        return metadata.getFeature(RDBFeatures.select).map(builder -> builder.createFragments(parameter)).filter(SqlFragments::isNotEmpty);
    }

    protected Optional<SqlFragments> where(QueryOperatorParameter parameter, TableOrViewMetadata metadata) {
        return metadata.getFeature(RDBFeatures.where).map(builder -> builder.createFragments(parameter)).filter(SqlFragments::isNotEmpty);
    }

    protected Optional<SqlFragments> join(QueryOperatorParameter parameter, TableOrViewMetadata metadata) {
        return metadata.getFeature(RDBFeatures.selectJoin).map(builder -> builder.createFragments(parameter)).filter(SqlFragments::isNotEmpty);
    }

    protected Optional<SqlFragments> orderBy(QueryOperatorParameter parameter, TableOrViewMetadata metadata) {
        return metadata.getFeature(RDBFeatures.orderBy).map(builder -> builder.createFragments(parameter)).filter(SqlFragments::isNotEmpty);
    }

    protected SqlFragments from(TableOrViewMetadata metadata, QueryOperatorParameter parameter) {
        return SqlFragments.of("from", metadata.getFullName(), parameter.getFromAlias());
    }

    protected Optional<SqlFragments> groupBy(QueryOperatorParameter parameter, TableOrViewMetadata metadata) {
        List<SelectColumn> groupBy = parameter.getGroupBy();
        if (CollectionUtils.isEmpty(groupBy)) {
            return Optional.empty();
        }
        BatchSqlFragments sql = new BatchSqlFragments(groupBy.size() * 2 - 1, 0);
        int idx = 0;
        for (SelectColumn column : groupBy) {
            if (idx++ > 0) {
                sql.add(SqlFragments.COMMA);
            }
            if (column instanceof NativeSql) {
                sql.addSql(((NativeSql)((Object)column)).getSql()).addParameter(((NativeSql)((Object)column)).getParameters());
                continue;
            }
            RDBColumnMetadata columnMetadata = metadata.getColumnNow(column.getColumn());
            String fullName = columnMetadata.getFullName();
            String function = column.getFunction();
            if (function != null) {
                SqlFragments func = ((FunctionFragmentBuilder)metadata.findFeatureNow(FunctionFragmentBuilder.createFeatureId(function))).create(fullName, columnMetadata, column);
                if (func.isEmpty()) {
                    throw new UnsupportedOperationException("unsupported function:" + function);
                }
                sql.add(func);
                continue;
            }
            sql.addSql(fullName);
        }
        return Optional.of(sql);
    }

    protected SqlRequest build(TableOrViewMetadata metadata, QueryOperatorParameter parameter) {
        BlockSqlFragments fragments = BlockSqlFragments.of();
        fragments.addBlock(FragmentBlock.before, SELECT);
        fragments.addBlock(FragmentBlock.selectColumn, this.select(parameter, metadata).orElseGet(() -> PrepareSqlFragments.of().addSql("*")));
        fragments.addBlock(FragmentBlock.selectFrom, this.from(metadata, parameter));
        this.join(parameter, metadata).ifPresent(join -> fragments.addBlock(FragmentBlock.join, (SqlFragments)join));
        this.where(parameter, metadata).ifPresent(where -> fragments.addBlock(FragmentBlock.where, WHERE).addBlock(FragmentBlock.where, (SqlFragments)where));
        this.groupBy(parameter, metadata).ifPresent(groupBy -> fragments.addBlock(FragmentBlock.groupBy, GROUP_BY).addBlock(FragmentBlock.groupBy, (SqlFragments)groupBy));
        this.orderBy(parameter, metadata).ifPresent(order -> fragments.addBlock(FragmentBlock.orderBy, ORDER_BY).addBlock(FragmentBlock.orderBy, (SqlFragments)order));
        if (Boolean.TRUE.equals(parameter.getForUpdate())) {
            fragments.addBlock(FragmentBlock.after, FOR_UPDATE);
        } else if (parameter.getPageIndex() != null && parameter.getPageSize() != null) {
            return metadata.findFeature(RDBFeatureType.paginator.getId()).map(paginator -> paginator.doPaging(fragments, parameter.getPageIndex(), parameter.getPageSize())).map(SqlFragments::toRequest).orElseGet(fragments::toRequest);
        }
        return fragments.toRequest();
    }

    @Override
    public SqlRequest build(QueryOperatorParameter parameter) {
        String from = parameter.getFrom();
        if (from == null || from.isEmpty()) {
            throw new UnsupportedOperationException("from table or view not set");
        }
        TableOrViewMetadata metadata = this.schema.findTableOrView(from).orElseThrow(() -> new UnsupportedOperationException("table or view [" + from + "] doesn't exist "));
        return this.build(metadata, parameter);
    }

    @Override
    public Mono<SqlRequest> buildAsync(QueryOperatorParameter parameter) {
        String from = parameter.getFrom();
        if (from == null || from.isEmpty()) {
            throw new UnsupportedOperationException("from table or view not set");
        }
        return this.schema.findTableOrViewReactive(from).switchIfEmpty(Mono.error(() -> new UnsupportedOperationException("table or view [" + from + "] doesn't exist "))).map(metadata -> this.build((TableOrViewMetadata)metadata, parameter));
    }
}

