/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.builder.fragments;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.TableOrViewMetadata;
import org.hswebframework.ezorm.rdb.metadata.key.ForeignKeyMetadata;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.AbstractTermsFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.EmptySqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.NativeSql;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SimpleSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.TermFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.term.ForeignKeyTermFragmentBuilder;

public class SimpleTermsFragmentBuilder
extends AbstractTermsFragmentBuilder<TableOrViewMetadata> {
    private static final SimpleTermsFragmentBuilder INSTANCE = new SimpleTermsFragmentBuilder();

    private SimpleTermsFragmentBuilder() {
    }

    public static SimpleTermsFragmentBuilder instance() {
        return INSTANCE;
    }

    @Override
    public SqlFragments createTermFragments(TableOrViewMetadata parameter, List<Term> terms) {
        return super.createTermFragments(parameter, terms);
    }

    @Override
    protected SqlFragments createTermFragments(TableOrViewMetadata table, Term term) {
        return SimpleTermsFragmentBuilder.createByTable(table, term);
    }

    public static SqlFragments createByTable(TableOrViewMetadata table, Term term) {
        RDBColumnMetadata column;
        String columnName = term.getColumn();
        if (columnName == null) {
            if (term.getValue() instanceof NativeSql) {
                NativeSql sql = (NativeSql)term.getValue();
                return SimpleSqlFragments.of(sql.getSql(), sql.getParameters());
            }
            return EmptySqlFragments.INSTANCE;
        }
        if (columnName.contains(".")) {
            String[] arr = columnName.split("[.]");
            if (table.equalsNameOrAlias(arr[0])) {
                columnName = arr[1];
            } else {
                return table.getForeignKey(arr[0]).flatMap(key -> key.getSource().findFeature(ForeignKeyTermFragmentBuilder.ID).map(builder -> builder.createFragments(table.getName(), (ForeignKeyMetadata)key, SimpleTermsFragmentBuilder.createForeignKeyTerm(key, term)))).orElse(EmptySqlFragments.INSTANCE);
            }
        }
        if ((column = (RDBColumnMetadata)table.getColumn(columnName).orElse(null)) == null) {
            return EmptySqlFragments.INSTANCE;
        }
        TermFragmentBuilder builder = column.findFeature(TermFragmentBuilder.createFeatureId(term.getTermType())).orElse(null);
        if (builder != null) {
            return builder.createFragments(column.getQuoteName(), column, term);
        }
        return EmptySqlFragments.INSTANCE;
    }

    static List<Term> createForeignKeyTerm(ForeignKeyMetadata keyMetadata, Term term) {
        Term copy = term.clone();
        term.setTerms(new LinkedList());
        return Collections.singletonList(copy);
    }
}

