/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.builder.fragments;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hswebframework.ezorm.core.utils.StringUtils;
import org.hswebframework.ezorm.rdb.executor.EmptySqlRequest;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.executor.SqlRequests;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.EmptySqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SimpleSqlFragments;

public interface SqlFragments {
    public static final SqlFragments LEFT_BRACKET = SqlFragments.single("(");
    public static final SqlFragments RIGHT_BRACKET = SqlFragments.single(")");
    public static final SqlFragments COMMA = SqlFragments.single(",");
    public static final SqlFragments EQUAL = SqlFragments.single("=");
    public static final SqlFragments NOT_EQUAL = SqlFragments.single("!=");
    public static final SqlFragments WHERE = SqlFragments.single("where");
    public static final SqlFragments AND = SqlFragments.single("and");
    public static final SqlFragments OR = SqlFragments.single("or");
    public static final SqlFragments NOT = SqlFragments.single("not");
    public static final SqlFragments QUESTION_MARK = SqlFragments.single("?");
    public static final SqlFragments ZERO = SqlFragments.single("0");
    public static final SqlFragments ONE = SqlFragments.single("1");

    public boolean isEmpty();

    default public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public List<String> getSql();

    public List<Object> getParameters();

    default public SqlRequest toRequest() {
        if (this.isEmpty()) {
            return EmptySqlRequest.INSTANCE;
        }
        return SqlRequests.prepare(StringUtils.join((CharSequence)" ", this.getSql()), this.getParameters().toArray());
    }

    public static SqlFragments single(String sql) {
        return SimpleSqlFragments.of(Collections.singletonList(sql), Collections.emptyList());
    }

    public static SqlFragments of(String ... sql) {
        if (sql == null || sql.length == 0) {
            return EmptySqlFragments.INSTANCE;
        }
        if (sql.length == 1) {
            return SqlFragments.single(sql[0]);
        }
        return SimpleSqlFragments.of(Arrays.asList(sql), Collections.emptyList());
    }
}

