/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.builder.fragments.delete;

import org.apache.commons.collections.CollectionUtils;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.AbstractTermsFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.BatchSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SimpleTermsFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.delete.DeleteSqlBuilder;
import org.hswebframework.ezorm.rdb.operator.dml.delete.DeleteOperatorParameter;

public class DefaultDeleteSqlBuilder
extends AbstractTermsFragmentBuilder<DeleteOperatorParameter>
implements DeleteSqlBuilder {
    private final RDBTableMetadata table;
    private SqlFragments DELETE;

    @Override
    public SqlRequest build(DeleteOperatorParameter parameter) {
        if (CollectionUtils.isEmpty(parameter.getWhere())) {
            throw new UnsupportedOperationException("Unsupported No Conditions delete");
        }
        if (this.DELETE == null) {
            this.DELETE = SqlFragments.of("delete from", this.table.getFullName(), "where");
        }
        BatchSqlFragments fragments = new BatchSqlFragments(2, 1);
        fragments.add(this.DELETE);
        SqlFragments where = this.createTermFragments(parameter, parameter.getWhere());
        if (where.isEmpty()) {
            throw new UnsupportedOperationException("Unsupported No Conditions delete");
        }
        fragments.addFragments(where);
        return fragments.toRequest();
    }

    @Override
    protected SqlFragments createTermFragments(DeleteOperatorParameter parameter, Term term) {
        return SimpleTermsFragmentBuilder.createByTable(this.table, term);
    }

    private DefaultDeleteSqlBuilder(RDBTableMetadata table) {
        this.table = table;
    }

    public static DefaultDeleteSqlBuilder of(RDBTableMetadata table) {
        return new DefaultDeleteSqlBuilder(table);
    }
}

