/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.builder.fragments.term;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.TableOrViewMetadata;
import org.hswebframework.ezorm.rdb.metadata.dialect.Dialect;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.AppendableSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.NativeSql;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.TermFragmentBuilder;

public abstract class AbstractTermFragmentBuilder
implements TermFragmentBuilder {
    private final String termType;
    private final String name;

    protected List<Object> convertList(RDBColumnMetadata column, Term term) {
        Object value = term.getValue();
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof String) {
            value = ((String)value).split(",");
        }
        if (value instanceof Object[]) {
            value = Arrays.asList((Object[])value);
        }
        if (value instanceof Collection) {
            Collection listValue = (Collection)value;
            if (listValue instanceof List) {
                return Lists.transform((List)((List)listValue), val -> this.convertValue(column, val));
            }
            ArrayList<Object> list = new ArrayList<Object>(listValue.size());
            for (Object val2 : listValue) {
                list.add(this.convertValue(column, val2));
            }
            return list;
        }
        return Arrays.asList(this.convertValue(column, value));
    }

    protected TableOrViewMetadata getTable(String tableName, RDBColumnMetadata baseOn) {
        return baseOn.getOwner().getSchema().getTableOrView(tableName).orElseThrow(() -> new UnsupportedOperationException("table " + tableName + " does not exist"));
    }

    protected String getTableName(String tableName, RDBColumnMetadata baseOn) {
        return this.getTable(tableName, baseOn).getFullName();
    }

    protected String buildColumnFullName(String column, RDBColumnMetadata baseOn) {
        String table = baseOn.getOwner().getName();
        return baseOn.getDialect().buildColumnFullName(table, column);
    }

    private Object convertValue(RDBColumnMetadata column, Object val) {
        if (column == null) {
            return val;
        }
        return column.encode(val);
    }

    protected Object convertValue(RDBColumnMetadata column, Term term) {
        if (term.getValue() instanceof NativeSql) {
            return term.getValue();
        }
        return this.convertValue(column, term.getValue());
    }

    protected <T extends AppendableSqlFragments> T appendPrepareOrNative(T sql, Object value) {
        if (value instanceof NativeSql) {
            NativeSql nativeSql = (NativeSql)value;
            sql.addSql(nativeSql.getSql()).addParameter(nativeSql.getParameters());
        } else {
            sql.add(SqlFragments.QUESTION_MARK).addParameter(value);
        }
        return sql;
    }

    protected static Optional<String> parseTablePlainName(String columnFullName, Dialect dialect) {
        if (columnFullName.contains(".")) {
            String[] split = AbstractTermFragmentBuilder.parsePlainName(columnFullName, dialect).split("\\.");
            return Optional.of(split[0]);
        }
        return Optional.empty();
    }

    protected static String parsePlainName(String name, Dialect dialect) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        if (name.startsWith(dialect.getQuoteStart())) {
            return name.substring(dialect.getQuoteStart().length(), name.length() - dialect.getQuoteEnd().length());
        }
        return name;
    }

    public AbstractTermFragmentBuilder(String termType, String name) {
        this.termType = termType;
        this.name = name;
    }

    @Override
    public String getTermType() {
        return this.termType;
    }

    public String getName() {
        return this.name;
    }
}

