/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.dml.update;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hswebframework.ezorm.core.Conditional;
import org.hswebframework.ezorm.core.MethodReferenceColumn;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.operator.dml.TermSupplier;
import org.hswebframework.ezorm.rdb.operator.dml.update.NativeSqlUpdateColumn;
import org.hswebframework.ezorm.rdb.operator.dml.update.UpdateColumn;
import org.hswebframework.ezorm.rdb.operator.dml.update.UpdateResultOperator;

public abstract class UpdateOperator {
    @SafeVarargs
    public final <T> UpdateOperator set(MethodReferenceColumn<T> ... columnValues) {
        for (MethodReferenceColumn<T> columnValue : columnValues) {
            this.set(columnValue.getColumn(), columnValue.get());
        }
        return this;
    }

    @SafeVarargs
    public final UpdateOperator set(Supplier<? extends UpdateColumn> ... columns) {
        for (Supplier<? extends UpdateColumn> column : columns) {
            this.set(column.get());
        }
        return this;
    }

    public UpdateOperator set(String column, String sql, Object ... parameter) {
        return this.set(NativeSqlUpdateColumn.of(column, sql, parameter));
    }

    public UpdateOperator set(Map<String, Object> values) {
        values.forEach(this::set);
        return this;
    }

    public abstract UpdateOperator set(String var1, Object var2);

    public abstract UpdateOperator set(UpdateColumn var1);

    @Deprecated
    public abstract UpdateOperator set(Object var1);

    public abstract UpdateOperator where(Consumer<Conditional<?>> var1);

    public abstract UpdateOperator where(Term var1);

    public final UpdateOperator where(TermSupplier ... condition) {
        for (TermSupplier operator : condition) {
            this.where((Term)operator.get());
        }
        return this;
    }

    public UpdateOperator accept(Consumer<UpdateOperator> consumer) {
        consumer.accept(this);
        return this;
    }

    public abstract SqlRequest getSql();

    public abstract UpdateResultOperator execute();
}

