/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.supports.h2;

import java.sql.SQLException;
import java.util.Collections;
import org.hswebframework.ezorm.rdb.exception.DuplicateKeyException;
import org.hswebframework.ezorm.rdb.metadata.RDBSchemaMetadata;
import org.hswebframework.ezorm.rdb.operator.ExceptionTranslation;

public class H2JDBCExceptionTranslation
implements ExceptionTranslation {
    private final RDBSchemaMetadata schema;

    @Override
    public Throwable translate(Throwable e) {
        SQLException exception;
        if (e instanceof SQLException && (exception = (SQLException)e).getErrorCode() == 23505) {
            throw new DuplicateKeyException(true, Collections.emptyList(), e);
        }
        return e;
    }

    private H2JDBCExceptionTranslation(RDBSchemaMetadata schema) {
        this.schema = schema;
    }

    public static H2JDBCExceptionTranslation of(RDBSchemaMetadata schema) {
        return new H2JDBCExceptionTranslation(schema);
    }
}

