/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.supports.h2;

import org.hswebframework.ezorm.core.meta.Feature;
import org.hswebframework.ezorm.rdb.codec.EnumValueCodec;
import org.hswebframework.ezorm.rdb.metadata.RDBSchemaMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.metadata.dialect.Dialect;
import org.hswebframework.ezorm.rdb.operator.CompositeExceptionTranslation;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.insert.BatchInsertSqlBuilder;
import org.hswebframework.ezorm.rdb.supports.h2.H2AlterTableSqlBuilder;
import org.hswebframework.ezorm.rdb.supports.h2.H2CreateTableSqlBuilder;
import org.hswebframework.ezorm.rdb.supports.h2.H2EnumInFragmentBuilder;
import org.hswebframework.ezorm.rdb.supports.h2.H2IndexMetadataParser;
import org.hswebframework.ezorm.rdb.supports.h2.H2JDBCExceptionTranslation;
import org.hswebframework.ezorm.rdb.supports.h2.H2Paginator;
import org.hswebframework.ezorm.rdb.supports.h2.H2R2DBCExceptionTranslation;
import org.hswebframework.ezorm.rdb.supports.h2.H2TableMetadataParser;
import org.hswebframework.ezorm.rdb.utils.FeatureUtils;

public class H2SchemaMetadata
extends RDBSchemaMetadata {
    public H2SchemaMetadata(String name) {
        super(name);
        this.addFeature(new H2CreateTableSqlBuilder());
        this.addFeature(new H2AlterTableSqlBuilder());
        this.addFeature(new H2Paginator());
        this.addFeature((Feature)new H2IndexMetadataParser(this));
        this.addFeature((Feature)new H2TableMetadataParser(this));
        this.addFeature(Dialect.H2);
        this.addFeature(new CompositeExceptionTranslation().add(FeatureUtils.r2dbcIsAlive(), () -> H2R2DBCExceptionTranslation.of(this)).add(H2JDBCExceptionTranslation.of(this)));
    }

    @Override
    public RDBTableMetadata newTable(String name) {
        RDBTableMetadata metadata = super.newTable(name);
        metadata.addFeature(BatchInsertSqlBuilder.of(metadata));
        metadata.setOnColumnAdded(column -> {
            if (column.getValueCodec() instanceof EnumValueCodec && ((EnumValueCodec)column.getValueCodec()).isToMask()) {
                column.addFeature(H2EnumInFragmentBuilder.in);
                column.addFeature(H2EnumInFragmentBuilder.notIn);
            }
        });
        return metadata;
    }

    @Override
    public void addTable(RDBTableMetadata metadata) {
        metadata.addFeature(BatchInsertSqlBuilder.of(metadata));
        super.addTable(metadata);
    }
}

