/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.supports.mssql;

import java.util.Arrays;
import java.util.LinkedList;
import org.hswebframework.ezorm.rdb.operator.builder.FragmentBlock;
import org.hswebframework.ezorm.rdb.operator.builder.Paginator;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.AppendableSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.BatchSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.BlockSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SimpleSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;

public class SqlServer2012Paginator
implements Paginator {
    static final SqlFragments ORDER_BY_NULL = SqlFragments.of("order by", "(select null)");
    static final SqlFragments OFFSET = SqlFragments.of("offset ? rows fetch next ? rows only");

    @Override
    public SqlFragments doPaging(SqlFragments fragments, int pageIndex, int pageSize) {
        boolean noOrder;
        if (fragments instanceof BlockSqlFragments) {
            BlockSqlFragments block = (BlockSqlFragments)fragments;
            LinkedList<SqlFragments> orderBy = block.getBlock(FragmentBlock.orderBy);
            if (orderBy.isEmpty()) {
                orderBy.add(ORDER_BY_NULL);
            }
            block.addBlock(FragmentBlock.after, SimpleSqlFragments.of(OFFSET.getSql(), Arrays.asList(pageIndex * pageSize, pageSize)));
            return block;
        }
        boolean bl = noOrder = !fragments.getSql().contains("order by") && !fragments.getSql().contains("ORDER BY");
        if (!(fragments instanceof AppendableSqlFragments)) {
            fragments = new BatchSqlFragments(3, 2).add(fragments);
        }
        AppendableSqlFragments sqlFragments = (AppendableSqlFragments)fragments;
        if (noOrder) {
            sqlFragments.add(ORDER_BY_NULL);
        }
        sqlFragments.add(OFFSET).addParameter(pageIndex * pageSize, pageSize);
        return sqlFragments;
    }
}

