/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.supports.mssql;

import java.util.List;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.rdb.operator.builder.FragmentBlock;
import org.hswebframework.ezorm.rdb.operator.builder.Paginator;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.BlockSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SimpleSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerPaginator
implements Paginator {
    private static final Logger log = LoggerFactory.getLogger(SqlServerPaginator.class);

    @Override
    public SqlFragments doPaging(SqlFragments fragments, int pageIndex, int pageSize) {
        if (fragments instanceof BlockSqlFragments) {
            BlockSqlFragments newBlock = BlockSqlFragments.of();
            BlockSqlFragments block = (BlockSqlFragments)fragments;
            newBlock.addBlock(FragmentBlock.before, "select top " + pageSize + " * from (");
            block.getBlock(FragmentBlock.selectColumn).add(SqlFragments.single(", row_number() over(order by (SELECT 1)) as rownumber"));
            List newOrderBy = block.getBlock(FragmentBlock.orderBy).stream().map(frg -> SimpleSqlFragments.of(frg.getSql().stream().map(sql -> {
                if (sql.contains(".")) {
                    CharSequence[] arr = sql.split("[.]");
                    arr[0] = "_row";
                    return String.join((CharSequence)".", arr);
                }
                return sql;
            }).collect(Collectors.toList()), frg.getParameters())).collect(Collectors.toList());
            block.getBlock(FragmentBlock.orderBy).clear();
            newBlock.addBlock(FragmentBlock.other, block);
            newBlock.addBlock(FragmentBlock.after, SimpleSqlFragments.of(") _row where _row.rownumber > ?", pageIndex * pageSize));
            newBlock.getBlock(FragmentBlock.after).addAll(newOrderBy);
            return newBlock;
        }
        log.warn("unsupported sql fragments type [{}] paging ", fragments.getClass());
        return fragments;
    }
}

