/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.supports.postgres;

import io.r2dbc.postgresql.api.ErrorDetails;
import io.r2dbc.postgresql.api.PostgresqlException;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.rdb.exception.DuplicateKeyException;
import org.hswebframework.ezorm.rdb.metadata.RDBSchemaMetadata;
import org.hswebframework.ezorm.rdb.operator.ExceptionTranslation;

public class PostgresqlR2DBCExceptionTranslation
implements ExceptionTranslation {
    private RDBSchemaMetadata schema;

    @Override
    public Throwable translate(Throwable e) {
        ErrorDetails details;
        if (e instanceof PostgresqlException && Objects.equals((details = ((PostgresqlException)e).getErrorDetails()).getCode(), "23505") && details.getTableName().isPresent() && details.getConstraintName().isPresent()) {
            String tableName = (String)details.getTableName().get();
            String constraintName = (String)details.getConstraintName().get();
            return this.schema.getTable(tableName).flatMap(table -> table.getIndex(constraintName).map(idx -> new DuplicateKeyException(idx.isPrimaryKey(), idx.getColumns().stream().map(indexColumn -> table.getColumn(indexColumn.getColumn()).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList()), e))).orElseGet(() -> new DuplicateKeyException(false, Collections.emptyList(), e));
        }
        return e;
    }

    private PostgresqlR2DBCExceptionTranslation(RDBSchemaMetadata schema) {
        this.schema = schema;
    }

    public static PostgresqlR2DBCExceptionTranslation of(RDBSchemaMetadata schema) {
        return new PostgresqlR2DBCExceptionTranslation(schema);
    }
}

