/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.utils;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import reactor.util.annotation.NonNull;

public class FlatList<T>
extends AbstractList<T>
implements Iterable<T> {
    private final List<List<T>> nestedList;
    private int size = -1;

    public FlatList(List<List<T>> nestedList) {
        this.nestedList = nestedList;
    }

    @Override
    public T get(int index) {
        int currentIndex = 0;
        for (List<T> list : this.nestedList) {
            if (index < currentIndex + list.size()) {
                return list.get(index - currentIndex);
            }
            currentIndex += list.size();
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
    }

    @Override
    public boolean add(T t) {
        this.size = -1;
        return this.nestedList.get(this.nestedList.size() - 1).add(t);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.size = -1;
        return this.nestedList.add(c instanceof List ? (List<Object>)c : new ArrayList<T>(c));
    }

    @Override
    public T set(int index, T element) {
        int currentIndex = 0;
        for (List<T> list : this.nestedList) {
            if (index < currentIndex + list.size()) {
                return list.set(index - currentIndex, element);
            }
            currentIndex += list.size();
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
    }

    @Override
    public int size() {
        if (this.size == -1) {
            this.size = 0;
            for (List<T> list : this.nestedList) {
                this.size += list.size();
            }
        }
        return this.size;
    }

    @Override
    @NonNull
    public Object[] toArray() {
        Object[] arr = new Object[this.size()];
        int index = 0;
        for (List<T> ts : this.nestedList) {
            for (T t : ts) {
                arr[index++] = t;
            }
        }
        return arr;
    }

    @Override
    @NonNull
    public <T1> T1[] toArray(T1[] a) {
        int size = this.size();
        T1[] r = a.length >= size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        int index = 0;
        for (List<T> ts : this.nestedList) {
            for (T t : ts) {
                r[index++] = t;
            }
        }
        return r;
    }

    @Override
    @NonNull
    public Iterator<T> iterator() {
        return new FlatListIterator<T>(this.nestedList);
    }

    private static class FlatListIterator<T>
    implements Iterator<T> {
        private final Iterator<List<T>> outerIterator;
        private Iterator<T> innerIterator;

        public FlatListIterator(List<List<T>> nestedList) {
            this.outerIterator = nestedList.iterator();
            this.innerIterator = this.outerIterator.hasNext() ? this.outerIterator.next().iterator() : null;
        }

        @Override
        public boolean hasNext() {
            while (this.innerIterator != null && !this.innerIterator.hasNext()) {
                if (this.outerIterator.hasNext()) {
                    this.innerIterator = this.outerIterator.next().iterator();
                    continue;
                }
                this.innerIterator = null;
            }
            return this.innerIterator != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.innerIterator.next();
        }
    }
}

