/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.mapping.jpa;

import java.util.Optional;
import java.util.concurrent.Callable;
import javax.persistence.Table;
import org.hswebframework.ezorm.rdb.mapping.annotation.Comment;
import org.hswebframework.ezorm.rdb.mapping.jpa.JpaEntityTableMetadataParserProcessor;
import org.hswebframework.ezorm.rdb.mapping.parser.DataTypeResolver;
import org.hswebframework.ezorm.rdb.mapping.parser.DefaultDataTypeResolver;
import org.hswebframework.ezorm.rdb.mapping.parser.DefaultValueCodecResolver;
import org.hswebframework.ezorm.rdb.mapping.parser.EntityTableMetadataParser;
import org.hswebframework.ezorm.rdb.mapping.parser.ValueCodecResolver;
import org.hswebframework.ezorm.rdb.metadata.RDBDatabaseMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBSchemaMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.utils.AnnotationUtils;
import org.hswebframework.utils.ClassUtils;

public class JpaEntityTableMetadataParser
implements EntityTableMetadataParser {
    private Callable<RDBDatabaseMetadata> databaseMetadata;
    private DataTypeResolver dataTypeResolver = DefaultDataTypeResolver.INSTANCE;
    private ValueCodecResolver valueCodecResolver = DefaultValueCodecResolver.COMMONS;

    public void setDatabaseMetadata(Callable<RDBDatabaseMetadata> databaseMetadata) {
        this.databaseMetadata = databaseMetadata;
    }

    public void setDatabaseMetadata(RDBDatabaseMetadata databaseMetadata) {
        this.databaseMetadata = () -> databaseMetadata;
    }

    @Override
    public Optional<RDBTableMetadata> parseTableMetadata(Class<?> entityType) {
        Table table = AnnotationUtils.getAnnotation(entityType, Table.class);
        if (table == null) {
            return Optional.empty();
        }
        RDBDatabaseMetadata databaseMetadata = this.databaseMetadata.call();
        RDBSchemaMetadata schema = databaseMetadata.getSchema(table.schema()).orElseGet(() -> ((RDBDatabaseMetadata)databaseMetadata).getCurrentSchema());
        RDBTableMetadata tableMetadata = schema.newTable(table.name());
        Optional.ofNullable(ClassUtils.getAnnotation(entityType, Comment.class)).map(Comment::value).ifPresent(tableMetadata::setComment);
        JpaEntityTableMetadataParserProcessor parserProcessor = this.createProcessor(tableMetadata, entityType);
        parserProcessor.setDataTypeResolver(this.dataTypeResolver);
        parserProcessor.setValueCodecResolver(this.valueCodecResolver);
        parserProcessor.process();
        return Optional.of(tableMetadata);
    }

    protected JpaEntityTableMetadataParserProcessor createProcessor(RDBTableMetadata table, Class<?> type) {
        return new JpaEntityTableMetadataParserProcessor(table, type);
    }

    public void setDataTypeResolver(DataTypeResolver dataTypeResolver) {
        this.dataTypeResolver = dataTypeResolver;
    }

    public void setValueCodecResolver(ValueCodecResolver valueCodecResolver) {
        this.valueCodecResolver = valueCodecResolver;
    }
}

