/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.metadata.dialect;

import java.sql.SQLType;
import java.util.Optional;
import org.hswebframework.ezorm.core.meta.Feature;
import org.hswebframework.ezorm.core.utils.StringUtils;
import org.hswebframework.ezorm.rdb.metadata.DataType;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBFeatureType;
import org.hswebframework.ezorm.rdb.metadata.dialect.DataTypeBuilder;
import org.hswebframework.ezorm.rdb.supports.h2.H2Dialect;
import org.hswebframework.ezorm.rdb.supports.mssql.SqlServerDialect;
import org.hswebframework.ezorm.rdb.supports.mysql.MysqlDialect;
import org.hswebframework.ezorm.rdb.supports.oracle.OracleDialect;
import org.hswebframework.ezorm.rdb.supports.postgres.PostgresqlDialect;

public interface Dialect
extends Feature {
    public static final Dialect MYSQL = new MysqlDialect();
    public static final Dialect ORACLE = new OracleDialect();
    public static final Dialect H2 = new H2Dialect();
    public static final Dialect MSSQL = new SqlServerDialect();
    public static final Dialect POSTGRES = new PostgresqlDialect();

    default public RDBFeatureType getType() {
        return RDBFeatureType.dialect;
    }

    public void addDataTypeBuilder(String var1, DataTypeBuilder var2);

    public String buildColumnDataType(RDBColumnMetadata var1);

    public String getQuoteStart();

    public String getQuoteEnd();

    public String clearQuote(String var1);

    public boolean isColumnToUpperCase();

    public Optional<SQLType> convertSqlType(Class<?> var1);

    public DataType convertDataType(String var1);

    default public String quote(String keyword, boolean changeCase) {
        if (keyword.startsWith(this.getQuoteStart()) && keyword.endsWith(this.getQuoteEnd())) {
            return keyword;
        }
        return StringUtils.concat((Object[])new Object[]{this.getQuoteStart(), this.isColumnToUpperCase() && changeCase ? keyword.toUpperCase() : keyword, this.getQuoteEnd()});
    }

    default public String quote(String keyword) {
        return this.quote(keyword, true);
    }

    default public String buildColumnFullName(String tableName, String columnName) {
        return this.buildColumnFullName(tableName, columnName, true);
    }

    default public String buildColumnFullName(String tableName, String columnName, boolean changeCase) {
        if (columnName.contains(".")) {
            return columnName;
        }
        if (StringUtils.isNullOrEmpty((Object)tableName)) {
            return StringUtils.concat((Object[])new Object[]{this.getQuoteStart(), changeCase && this.isColumnToUpperCase() ? columnName.toUpperCase() : columnName, this.getQuoteEnd()});
        }
        return StringUtils.concat((Object[])new Object[]{tableName, ".", this.getQuoteStart(), changeCase && this.isColumnToUpperCase() ? columnName.toUpperCase() : columnName, this.getQuoteEnd()});
    }
}

