/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.supports.oracle;

import org.hswebframework.ezorm.rdb.operator.builder.FragmentBlock;
import org.hswebframework.ezorm.rdb.operator.builder.Paginator;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.BatchSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.BlockSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SimpleSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;

public class OraclePaginator
implements Paginator {
    static final SqlFragments PREFIX = SqlFragments.of("select * from ( SELECT row_.*, rownum rownum_ FROM (");
    static final String SUFFIX_SQL = ") row_ ) where rownum_ <= ?  AND rownum_ > ?";
    static final SqlFragments SUFFIX = SqlFragments.of(") row_ ) where rownum_ <= ?  AND rownum_ > ?");

    @Override
    public SqlFragments doPaging(SqlFragments fragments, int pageIndex, int pageSize) {
        if (fragments instanceof BlockSqlFragments) {
            BlockSqlFragments block = (BlockSqlFragments)fragments;
            block.addBlockFirst(FragmentBlock.before, PREFIX);
            block.addBlock(FragmentBlock.after, SimpleSqlFragments.of(SUFFIX_SQL, (pageIndex + 1) * pageSize, pageIndex * pageSize));
            return fragments;
        }
        BatchSqlFragments paging = new BatchSqlFragments(3, 2);
        paging.add(PREFIX).add(fragments).add(SUFFIX).addParameter((pageIndex + 1) * pageSize, pageIndex * pageSize);
        return paging;
    }
}

