/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.utils;

import java.util.function.Function;
import java.util.function.Supplier;
import org.hswebframework.ezorm.core.meta.FeatureSupportedMetadata;
import org.hswebframework.ezorm.rdb.operator.ExceptionTranslation;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ExceptionUtils {
    public static Throwable translation(FeatureSupportedMetadata metadata, Throwable e) {
        return metadata.findFeature(ExceptionTranslation.ID).map(trans -> trans.translate(e)).orElse(e);
    }

    public static <T> T translation(Supplier<T> supplier, FeatureSupportedMetadata metadata) {
        try {
            return supplier.get();
        }
        catch (Throwable r) {
            throw ExceptionUtils.translation(metadata, r);
        }
    }

    public static <T, P extends Publisher<T>> Function<P, P> translation(FeatureSupportedMetadata metadata) {
        return publisher -> {
            if (publisher instanceof Mono) {
                return ((Mono)publisher).onErrorMap(err -> ExceptionUtils.translation(metadata, err));
            }
            if (publisher instanceof Flux) {
                return ((Flux)publisher).onErrorMap(err -> ExceptionUtils.translation(metadata, err));
            }
            return publisher;
        };
    }
}

