/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.builder.fragments;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.AppendableSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;
import org.hswebframework.ezorm.rdb.utils.FlatList;

public class BatchSqlFragments
implements AppendableSqlFragments {
    private final List<List<String>> sql;
    private final List<List<Object>> parameter;

    public BatchSqlFragments() {
        this(8, 8);
    }

    public BatchSqlFragments(int sqlSize, int parameterSize) {
        this.sql = new ArrayList<List<String>>(sqlSize);
        this.parameter = new ArrayList<List<Object>>(parameterSize);
    }

    @Override
    public boolean isEmpty() {
        return this.sql.isEmpty();
    }

    @Override
    public BatchSqlFragments addFragments(SqlFragments fragments) {
        return this.addSql(fragments.getSql()).addParameters(fragments.getParameters());
    }

    public BatchSqlFragments addSql(String sql) {
        return this.addSql(Collections.singletonList(sql));
    }

    @Override
    public BatchSqlFragments addSql(Collection<String> sql) {
        List<Object> _sql = sql instanceof List ? (List<Object>)sql : new ArrayList<String>(sql);
        return this.addSql((List<String>)_sql);
    }

    public BatchSqlFragments addSql(List<String> sql) {
        if (!CollectionUtils.isEmpty(sql)) {
            this.sql.add(sql);
        }
        return this;
    }

    @Override
    public BatchSqlFragments addSql(String ... sql) {
        if (sql == null || sql.length == 0) {
            return this;
        }
        if (sql.length == 1) {
            return this.addSql(Collections.singletonList(sql[0]));
        }
        return this.addSql(Arrays.asList(sql));
    }

    public BatchSqlFragments addParameters(List<Object> parameters) {
        if (!CollectionUtils.isEmpty(parameters)) {
            this.parameter.add(parameters);
        }
        return this;
    }

    @Override
    public BatchSqlFragments addParameter(Collection<?> parameter) {
        if (CollectionUtils.isEmpty(parameter)) {
            return this;
        }
        return this.addParameters(parameter instanceof List ? (List<Object>)parameter : new ArrayList(parameter));
    }

    @Override
    public BatchSqlFragments addParameter(Object ... parameter) {
        if (parameter == null || parameter.length == 0) {
            return this;
        }
        return this.addParameters(Arrays.asList(parameter));
    }

    @Override
    public List<String> getSql() {
        return new FlatList<String>(this.sql);
    }

    @Override
    public List<Object> getParameters() {
        return new FlatList<Object>(this.parameter);
    }
}

