/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.supports.oracle;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hswebframework.ezorm.core.RuntimeDefaultValue;
import org.hswebframework.ezorm.rdb.executor.NullValue;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.BatchSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.NativeSql;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.function.FunctionFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.insert.InsertSqlBuilder;
import org.hswebframework.ezorm.rdb.operator.dml.insert.InsertColumn;
import org.hswebframework.ezorm.rdb.operator.dml.insert.InsertOperatorParameter;

public class OracleInsertSqlBuilder
implements InsertSqlBuilder {
    private final RDBTableMetadata table;
    private SqlFragments INTO_SQL;
    private static SqlFragments VALUES = SqlFragments.of("values (");
    private static SqlFragments INSERT = SqlFragments.of("insert");
    private static SqlFragments INSERT_ALL = SqlFragments.of("insert all");
    private static SqlFragments FROM_DUAL = SqlFragments.of("select 1 from dual");

    @Override
    public SqlRequest build(InsertOperatorParameter parameter) {
        if (this.INTO_SQL == null) {
            this.INTO_SQL = SqlFragments.of("into", this.table.getFullName(), "(");
        }
        LinkedHashMap<Integer, RDBColumnMetadata> indexMapping = new LinkedHashMap<Integer, RDBColumnMetadata>();
        LinkedHashMap<Integer, SqlFragments> functionValues = new LinkedHashMap<Integer, SqlFragments>();
        int index = 0;
        int primaryIndex = -1;
        Set<InsertColumn> columns = parameter.getColumns();
        for (InsertColumn column : columns) {
            RDBColumnMetadata columnMetadata = Optional.ofNullable(column.getColumn()).flatMap(this.table::getColumn).orElse(null);
            if (columnMetadata != null && columnMetadata.isInsertable()) {
                if (columnMetadata.isPrimaryKey()) {
                    primaryIndex = index;
                }
                indexMapping.put(index, columnMetadata);
                if (StringUtils.isNotEmpty((CharSequence)column.getFunction())) {
                    functionValues.put(index, ((FunctionFragmentBuilder)columnMetadata.findFeatureNow(FunctionFragmentBuilder.createFeatureId(column.getFunction()))).create(columnMetadata.getName(), columnMetadata, column));
                }
            }
            ++index;
        }
        if (indexMapping.isEmpty()) {
            throw new IllegalArgumentException("No operable columns");
        }
        int valueSize = parameter.getValues().size();
        int columnSize = indexMapping.size();
        boolean batch = valueSize > 1;
        BatchSqlFragments fragments = new BatchSqlFragments(3 + valueSize * 2, valueSize * 2);
        if (batch) {
            fragments.add(INSERT_ALL);
        } else {
            fragments.add(INSERT);
        }
        HashSet<Object> duplicatePrimary = new HashSet<Object>();
        for (List<Object> values : parameter.getValues()) {
            BatchSqlFragments intoSql = new BatchSqlFragments(columnSize * 2 + 1, 0);
            BatchSqlFragments valuesSql = new BatchSqlFragments(columnSize * 2 + 1, columnSize);
            int valueLen = values.size();
            int vIndex = 0;
            if (primaryIndex >= 0 && values.size() > primaryIndex && !duplicatePrimary.add(values.get(primaryIndex))) continue;
            intoSql.add(this.INTO_SQL);
            valuesSql.add(VALUES);
            for (Map.Entry entry : indexMapping.entrySet()) {
                Object value;
                SqlFragments function;
                RDBColumnMetadata column = (RDBColumnMetadata)entry.getValue();
                int valueIndex = (Integer)entry.getKey();
                if (vIndex++ != 0) {
                    intoSql.add(SqlFragments.COMMA);
                    valuesSql.add(SqlFragments.COMMA);
                }
                if (null != (function = (SqlFragments)functionValues.get(valueIndex))) {
                    valuesSql.addFragments(function);
                    continue;
                }
                Object object = value = valueLen <= valueIndex ? null : values.get(valueIndex);
                if ((value == null || value instanceof NullValue) && column.getDefaultValue() instanceof RuntimeDefaultValue) {
                    value = ((RuntimeDefaultValue)column.getDefaultValue()).get();
                }
                intoSql.addSql(column.getQuoteName());
                if (value instanceof NativeSql) {
                    valuesSql.addSql(((NativeSql)value).getSql()).addParameter(((NativeSql)value).getParameters());
                    continue;
                }
                if (value == null) {
                    value = NullValue.of(column.getType());
                }
                valuesSql.add(SqlFragments.QUESTION_MARK).addParameter(column.encode(value));
            }
            intoSql.add(SqlFragments.RIGHT_BRACKET);
            valuesSql.add(SqlFragments.RIGHT_BRACKET);
            fragments.addFragments(intoSql).addFragments(valuesSql);
        }
        if (batch) {
            fragments.add(FROM_DUAL);
        }
        return fragments.toRequest();
    }

    private OracleInsertSqlBuilder(RDBTableMetadata table) {
        this.table = table;
    }

    public static OracleInsertSqlBuilder of(RDBTableMetadata table) {
        return new OracleInsertSqlBuilder(table);
    }
}

