/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.codec;

import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.core.ValueCodec;
import org.hswebframework.utils.DateTimeUtils;
import org.hswebframework.utils.time.DateFormatter;
import org.joda.time.format.DateTimeFormat;

public class DateTimeCodec
implements ValueCodec {
    private String format;
    private Class<?> toType;

    public DateTimeCodec(String format, Class<?> toType) {
        this.format = format;
        this.toType = toType;
    }

    protected java.util.Date doParse(String dateString) {
        java.util.Date smartFormat = DateFormatter.fromString((String)dateString);
        if (smartFormat != null) {
            return smartFormat;
        }
        try {
            long timestampMaybe = Long.parseLong(dateString);
            if (timestampMaybe > 0L) {
                return java.util.Date.from(Instant.ofEpochMilli(timestampMaybe));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return DateTimeFormat.forPattern((String)this.format).parseDateTime(dateString).toDate();
    }

    public Object encode(Object value) {
        if (value instanceof java.util.Date) {
            return value;
        }
        if (value instanceof Number) {
            return new java.util.Date(((Number)value).longValue());
        }
        if (value instanceof String) {
            if (((String)value).contains(",")) {
                return Arrays.stream(((String)value).split(",")).map(this::doParse).filter(Objects::nonNull).collect(Collectors.toList());
            }
            return this.doParse((String)value);
        }
        return value;
    }

    public Object decode(Object data) {
        if (null == data) {
            return null;
        }
        if (this.toType.isAssignableFrom(data.getClass())) {
            return data;
        }
        if (data instanceof Date) {
            data = new java.util.Date(((Date)data).getTime());
        }
        if (!(data instanceof java.util.Date)) {
            data = this.toDate(data);
        }
        if (data instanceof Collection) {
            return ((Collection)data).stream().map(this::decode).collect(this.toType == String.class ? Collectors.joining(",") : Collectors.toList());
        }
        if (!(data instanceof java.util.Date)) {
            return data;
        }
        if (this.toType == java.util.Date.class) {
            return data;
        }
        if (this.toType == Instant.class) {
            return ((java.util.Date)data).toInstant();
        }
        if (this.toType == LocalDateTime.class) {
            return LocalDateTime.ofInstant(((java.util.Date)data).toInstant(), ZoneId.systemDefault());
        }
        if (this.toType == LocalDate.class) {
            return LocalDateTime.ofInstant(((java.util.Date)data).toInstant(), ZoneId.systemDefault()).toLocalDate();
        }
        if (this.toType == LocalTime.class) {
            return LocalDateTime.ofInstant(((java.util.Date)data).toInstant(), ZoneId.systemDefault()).toLocalTime();
        }
        if (this.toType == String.class) {
            return DateTimeUtils.format((java.util.Date)((java.util.Date)data), (String)this.format);
        }
        if (this.toType == Timestamp.class) {
            return new Timestamp(((java.util.Date)data).getTime());
        }
        return data;
    }

    public Object toDate(Object data) {
        if (data instanceof Number) {
            data = new java.util.Date(((Number)data).longValue());
        } else if (data instanceof Timestamp) {
            data = java.util.Date.from(((Timestamp)data).toInstant());
        } else if (data instanceof Instant) {
            data = java.util.Date.from((Instant)data);
        } else if (data instanceof LocalDateTime) {
            LocalDateTime dateTime = (LocalDateTime)data;
            data = java.util.Date.from(dateTime.atZone(ZoneOffset.systemDefault()).toInstant());
        } else if (data instanceof ZonedDateTime) {
            ZonedDateTime dateTime = (ZonedDateTime)data;
            data = java.util.Date.from(dateTime.toInstant());
        } else if (data instanceof OffsetDateTime) {
            data = java.util.Date.from(((OffsetDateTime)data).toInstant());
        } else if (data instanceof String) {
            String stringData = (String)data;
            if (stringData.contains(",")) {
                return Arrays.stream(stringData.split(",")).map(this::doParse).filter(Objects::nonNull).collect(Collectors.toList());
            }
            return this.doParse(stringData);
        }
        return data;
    }

    public DateTimeCodec() {
    }
}

