/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.builder.fragments;

import java.util.HashMap;
import org.hswebframework.ezorm.core.FeatureId;
import org.hswebframework.ezorm.core.meta.Feature;
import org.hswebframework.ezorm.rdb.metadata.RDBFeatureType;

public class DynamicFeatures {
    private static final Cache[] caches;

    public static <T extends Feature> FeatureId<T> lookup(RDBFeatureType featureType, String id) {
        return caches[featureType.ordinal()].getOrLoad(id);
    }

    static {
        RDBFeatureType[] all = RDBFeatureType.values();
        caches = new Cache[all.length];
        for (int i = 0; i < all.length; ++i) {
            DynamicFeatures.caches[i] = new Cache(all[i]);
        }
    }

    static class CacheKey {
        private RDBFeatureType type;
        private String id;

        public CacheKey(RDBFeatureType type, String id) {
            this.type = type;
            this.id = id;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            RDBFeatureType this$type = this.type;
            RDBFeatureType other$type = other.type;
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            String this$id = this.id;
            String other$id = other.id;
            return !(this$id == null ? other$id != null : !this$id.equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CacheKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            RDBFeatureType $type = this.type;
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            String $id = this.id;
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            return result;
        }
    }

    static class Cache
    extends HashMap<String, FeatureId<?>> {
        private final RDBFeatureType type;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FeatureId<?> getOrLoad(String id) {
            FeatureId val = (FeatureId)super.get(id);
            if (val == null) {
                Cache cache = this;
                synchronized (cache) {
                    val = FeatureId.of((String)this.type.getFeatureId(id.toLowerCase()));
                    this.put(id, val);
                }
            }
            return val;
        }

        public Cache(RDBFeatureType type) {
            this.type = type;
        }
    }
}

