/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.dml.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.operator.dml.Join;
import org.hswebframework.ezorm.rdb.operator.dml.query.SelectColumn;
import org.hswebframework.ezorm.rdb.operator.dml.query.SortOrder;

public class QueryOperatorParameter {
    private List<SelectColumn> select = new ArrayList<SelectColumn>();
    private List<SelectColumn> alias = new ArrayList<SelectColumn>();
    private Set<String> selectExcludes = new HashSet<String>();
    private String from;
    private String fromAlias;
    private List<Term> where = new ArrayList<Term>(5);
    private List<Join> joins = new ArrayList<Join>();
    private List<SortOrder> orderBy = new ArrayList<SortOrder>(2);
    private List<SelectColumn> groupBy = new ArrayList<SelectColumn>(2);
    private List<Term> having = new ArrayList<Term>();
    private Integer pageIndex;
    private Integer pageSize;
    private Boolean forUpdate;
    private Map<String, Object> context;

    public Optional<Join> findJoin(String targetName) {
        return Optional.ofNullable(this.joins).flatMap(_joins -> _joins.stream().filter(join -> join.equalsTargetOrAlias(targetName)).findFirst());
    }

    public String getFromAlias() {
        if (this.fromAlias == null) {
            return this.from;
        }
        return this.fromAlias;
    }

    public QueryOperatorParameter clone() {
        QueryOperatorParameter parameter = new QueryOperatorParameter();
        parameter.select.addAll(this.select);
        parameter.selectExcludes.addAll(this.selectExcludes);
        parameter.from = this.from;
        parameter.fromAlias = this.fromAlias;
        parameter.alias.addAll(this.alias);
        parameter.where.addAll(this.where);
        parameter.joins.addAll(this.joins);
        parameter.orderBy.addAll(this.orderBy);
        parameter.groupBy.addAll(this.groupBy);
        parameter.having.addAll(this.having);
        parameter.pageIndex = this.pageIndex;
        parameter.pageSize = this.pageSize;
        parameter.forUpdate = this.forUpdate;
        if (this.context != null) {
            parameter.context = new HashMap<String, Object>(this.context);
        }
        return parameter;
    }

    public List<SelectColumn> getSelect() {
        return this.select;
    }

    public List<SelectColumn> getAlias() {
        return this.alias;
    }

    public Set<String> getSelectExcludes() {
        return this.selectExcludes;
    }

    public String getFrom() {
        return this.from;
    }

    public List<Term> getWhere() {
        return this.where;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public List<SortOrder> getOrderBy() {
        return this.orderBy;
    }

    public List<SelectColumn> getGroupBy() {
        return this.groupBy;
    }

    public List<Term> getHaving() {
        return this.having;
    }

    public Integer getPageIndex() {
        return this.pageIndex;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Boolean getForUpdate() {
        return this.forUpdate;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public void setSelect(List<SelectColumn> select) {
        this.select = select;
    }

    public void setAlias(List<SelectColumn> alias) {
        this.alias = alias;
    }

    public void setSelectExcludes(Set<String> selectExcludes) {
        this.selectExcludes = selectExcludes;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setFromAlias(String fromAlias) {
        this.fromAlias = fromAlias;
    }

    public void setWhere(List<Term> where) {
        this.where = where;
    }

    public void setJoins(List<Join> joins) {
        this.joins = joins;
    }

    public void setOrderBy(List<SortOrder> orderBy) {
        this.orderBy = orderBy;
    }

    public void setGroupBy(List<SelectColumn> groupBy) {
        this.groupBy = groupBy;
    }

    public void setHaving(List<Term> having) {
        this.having = having;
    }

    public void setPageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setForUpdate(Boolean forUpdate) {
        this.forUpdate = forUpdate;
    }

    public void setContext(Map<String, Object> context) {
        this.context = context;
    }
}

