/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.supports.commons;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.rdb.executor.SqlRequests;
import org.hswebframework.ezorm.rdb.executor.SyncSqlExecutor;
import org.hswebframework.ezorm.rdb.executor.reactive.ReactiveSqlExecutor;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrappers;
import org.hswebframework.ezorm.rdb.mapping.defaults.record.Record;
import org.hswebframework.ezorm.rdb.mapping.defaults.record.RecordResultWrapper;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBIndexMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBSchemaMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.metadata.ValueCodecFactory;
import org.hswebframework.ezorm.rdb.metadata.dialect.Dialect;
import org.hswebframework.ezorm.rdb.metadata.parser.IndexMetadataParser;
import org.hswebframework.ezorm.rdb.metadata.parser.TableMetadataParser;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public abstract class RDBTableMetadataParser
implements TableMetadataParser {
    private static final Logger log = LoggerFactory.getLogger(RDBTableMetadataParser.class);
    static ContextView logContext = Context.of(Logger.class, (Object)log).readOnly();
    protected RDBSchemaMetadata schema;
    protected SyncSqlExecutor sqlExecutor;

    protected Dialect getDialect() {
        return this.schema.getDialect();
    }

    protected abstract String getTableMetaSql(String var1);

    protected abstract String getTableCommentSql(String var1);

    protected abstract String getAllTableSql();

    protected abstract String getTableExistsSql();

    public RDBTableMetadataParser(RDBSchemaMetadata schema) {
        this.schema = schema;
    }

    protected SyncSqlExecutor getSqlExecutor() {
        if (this.sqlExecutor == null) {
            this.sqlExecutor = (SyncSqlExecutor)this.schema.findFeatureNow(SyncSqlExecutor.ID);
        }
        return this.sqlExecutor;
    }

    protected ReactiveSqlExecutor getReactiveSqlExecutor() {
        return (ReactiveSqlExecutor)this.schema.findFeatureNow(ReactiveSqlExecutor.ID);
    }

    protected RDBTableMetadata createTable(String name) {
        return this.schema.newTable(name);
    }

    protected Optional<RDBTableMetadata> doParse(String name) {
        RDBTableMetadata metaData = this.createTable(name);
        metaData.setName(name);
        metaData.setAlias(name);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("table", name);
        param.put("schema", this.schema.getName());
        List<RDBColumnMetadata> metaDataList = this.getSqlExecutor().select(SqlRequests.template(this.getTableMetaSql(name), param), ResultWrappers.list(RecordResultWrapper.INSTANCE)).stream().map(record -> {
            RDBColumnMetadata column = metaData.newColumn();
            record.getString("table_name").ifPresent(metaData::setRealName);
            this.applyColumnInfo(column, (Record)record);
            return column;
        }).collect(Collectors.toList());
        metaDataList.forEach(metaData::addColumn);
        Map<String, Object> comment = this.getSqlExecutor().select(SqlRequests.template(this.getTableCommentSql(name), param), ResultWrappers.singleMap());
        if (null != comment && comment.get("comment") != null) {
            metaData.setComment(String.valueOf(comment.get("comment")));
        }
        this.schema.findFeature(IndexMetadataParser.ID).map(parser -> parser.parseTableIndex(name)).ifPresent(indexes -> indexes.forEach(metaData::addIndex));
        return Optional.of(metaData);
    }

    public Mono<RDBTableMetadata> parseByNameReactive(String name) {
        return this.tableExistsReactive(name).filter(Boolean::booleanValue).flatMap(ignore -> {
            RDBTableMetadata metaData = this.createTable(name);
            metaData.setName(name);
            metaData.setAlias(name);
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("table", name);
            param.put("schema", this.schema.getName());
            ReactiveSqlExecutor reactiveSqlExecutor = this.getReactiveSqlExecutor();
            Mono columns = reactiveSqlExecutor.select(SqlRequests.template(this.getTableMetaSql(name), param), new RecordResultWrapper()).map(record -> {
                record.getString("table_name").ifPresent(metaData::setRealName);
                RDBColumnMetadata column = metaData.newColumn();
                this.applyColumnInfo(column, (Record)record);
                metaData.addColumn(column);
                return column;
            }).collectList();
            Mono comments = reactiveSqlExecutor.select(SqlRequests.template(this.getTableCommentSql(name), param), ResultWrappers.singleMap()).doOnNext(comment -> metaData.setComment(String.valueOf(comment.get("comment")))).singleOrEmpty();
            Flux index = this.schema.findFeature(IndexMetadataParser.ID).map(parser -> parser.parseTableIndexReactive(name)).orElseGet(Flux::empty).doOnNext(metaData::addIndex);
            return Flux.concat((Publisher[])new Publisher[]{columns, comments, index}).then(Mono.just((Object)metaData));
        }).contextWrite(logContext);
    }

    public Flux<RDBTableMetadata> parseAllReactive() {
        return this.parseAllTableNameReactive().flatMap(this::parseByNameReactive).contextWrite(logContext);
    }

    public Optional<RDBTableMetadata> parseByName(String name) {
        if (!this.tableExists(name)) {
            return Optional.empty();
        }
        return this.doParse(name);
    }

    @Override
    public boolean tableExists(String name) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("table", name);
        param.put("schema", this.schema.getName());
        return this.getSqlExecutor().select(SqlRequests.template(this.getTableExistsSql(), param), ResultWrappers.optional(ResultWrappers.single(ResultWrappers.column("total", Number.class::cast)))).map(number -> number.intValue() > 0).orElse(false);
    }

    @Override
    public Mono<Boolean> tableExistsReactive(String name) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("table", name);
        param.put("schema", this.schema.getName());
        return this.getReactiveSqlExecutor().select(SqlRequests.template(this.getTableExistsSql(), param), ResultWrappers.column("total", Number.class::cast)).map(number -> number.intValue() > 0).singleOrEmpty().defaultIfEmpty((Object)false).contextWrite(logContext);
    }

    @Override
    public List<String> parseAllTableName() {
        return this.getSqlExecutor().select(SqlRequests.template(this.getAllTableSql(), Collections.singletonMap("schema", this.schema.getName())), ResultWrappers.list(ResultWrappers.column("name", String::valueOf)));
    }

    @Override
    public Flux<String> parseAllTableNameReactive() {
        return this.getReactiveSqlExecutor().select(SqlRequests.template(this.getAllTableSql(), Collections.singletonMap("schema", this.schema.getName())), ResultWrappers.list(ResultWrappers.column("name", String::valueOf))).contextWrite(logContext);
    }

    protected Flux<RDBTableMetadata> fastParseAllReactive() {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("table", "%%");
        param.put("schema", this.schema.getName());
        ConcurrentHashMap metadata = new ConcurrentHashMap();
        Mono columns = this.getReactiveSqlExecutor().select(SqlRequests.template(this.getTableMetaSql(null), param), new RecordResultWrapper()).doOnNext(record -> {
            String tableName = record.getString("table_name").orElseThrow(() -> new NullPointerException("table_name is null"));
            RDBTableMetadata tableMetadata = metadata.computeIfAbsent(tableName, __t -> {
                String lowerName = __t.toLowerCase();
                RDBTableMetadata metaData = this.createTable(lowerName);
                metaData.setName(lowerName);
                metaData.setAlias(lowerName);
                metaData.setRealName((String)__t);
                return metaData;
            });
            RDBColumnMetadata column = tableMetadata.newColumn();
            this.applyColumnInfo(column, (Record)record);
            tableMetadata.addColumn(column);
        }).then();
        Mono comments = this.getReactiveSqlExecutor().select(SqlRequests.template(this.getTableCommentSql(null), param), new RecordResultWrapper()).doOnNext(record -> record.getString("table_name").map(String::toLowerCase).map(metadata::get).ifPresent(table -> record.getString("comment").ifPresent(table::setComment))).then();
        Mono indexes = this.schema.findFeature(IndexMetadataParser.ID).map(IndexMetadataParser::parseAllReactive).orElseGet(Flux::empty).doOnNext(index -> Optional.ofNullable(metadata.get(index.getTableName())).ifPresent(table -> table.addIndex((RDBIndexMetadata)index))).then();
        return Flux.concat((Publisher[])new Publisher[]{columns, comments, indexes}).thenMany((Publisher)Flux.defer(() -> Flux.fromIterable(metadata.values()))).contextWrite(logContext);
    }

    protected List<RDBTableMetadata> fastParseAll() {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("table", "%%");
        param.put("schema", this.schema.getName());
        ConcurrentHashMap metadata = new ConcurrentHashMap();
        this.getSqlExecutor().select(SqlRequests.template(this.getTableMetaSql(null), param), ResultWrappers.consumer(new RecordResultWrapper(), record -> {
            String tableName = record.getString("table_name").orElseThrow(() -> new NullPointerException("table_name is null"));
            RDBTableMetadata tableMetadata = metadata.computeIfAbsent(tableName, __t -> {
                String lowerName = __t.toLowerCase();
                RDBTableMetadata metaData = this.createTable(lowerName);
                metaData.setName(lowerName);
                metaData.setAlias(lowerName);
                metaData.setRealName((String)__t);
                return metaData;
            });
            RDBColumnMetadata column = tableMetadata.newColumn();
            this.applyColumnInfo(column, (Record)record);
            tableMetadata.addColumn(column);
        }));
        this.getSqlExecutor().select(SqlRequests.template(this.getTableCommentSql(null), param), ResultWrappers.consumer(new RecordResultWrapper(), record -> record.getString("table_name").map(String::toLowerCase).map(metadata::get).ifPresent(table -> record.getString("comment").ifPresent(table::setComment))));
        this.schema.findFeature("indexMetadataParser").map(IndexMetadataParser::parseAll).ifPresent(indexes -> indexes.forEach(index -> Optional.ofNullable(metadata.get(index.getTableName())).ifPresent(table -> table.addIndex((RDBIndexMetadata)index))));
        return new ArrayList<RDBTableMetadata>(metadata.values());
    }

    protected void applyColumnInfo(RDBColumnMetadata column, Record record) {
        record.getString("name").ifPresent(name -> {
            column.setRealName((String)name);
            column.setName((String)name);
            column.setProperty("old-name", name);
        });
        record.getString("comment").ifPresent(arg_0 -> ((RDBColumnMetadata)column).setComment(arg_0));
        record.getString("not_null").ifPresent(value -> column.setNotNull("1".equals(value)));
        record.getInteger("data_length").ifPresent(column::setLength);
        record.getInteger("data_precision").ifPresent(column::setPrecision);
        record.getInteger("data_scale").ifPresent(column::setScale);
        record.getBoolean("primary_key").ifPresent(column::setPrimaryKey);
        Optional.ofNullable(record.getString("column_type").orElseGet(() -> record.getString("data_type").orElse(null))).map(String::toLowerCase).map(this.getDialect()::convertDataType).ifPresent(column::setType);
        if (column.getType() != null && column.getType().isNumber() && !record.get("data_precision").isPresent()) {
            column.setPrecision(column.getLength());
        }
        column.findFeature(ValueCodecFactory.ID).flatMap(factory -> factory.createValueCodec(column)).ifPresent(arg_0 -> ((RDBColumnMetadata)column).setValueCodec(arg_0));
    }

    public List<RDBTableMetadata> parseAll() {
        return this.parseAllTableName().parallelStream().map(this::doParse).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }
}

