/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.utils;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;

public class AnnotationUtils {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Optional<Field> getFiledByDescriptor(Class<?> type, PropertyDescriptor descriptor) {
        String name = descriptor.getName();
        while (true) {
            try {
                return Optional.of(type.getDeclaredField(name));
            }
            catch (NoSuchFieldException e1) {
                try {
                    char[] arr = name.toCharArray();
                    if (!Character.isUpperCase(arr[0])) throw e1;
                    arr[0] = Character.toLowerCase(arr[0]);
                    name = new String(arr);
                    continue;
                }
                catch (NoSuchFieldException e) {
                    if ((type = type.getSuperclass()) == null || type == Object.class) return Optional.empty();
                    continue;
                }
            }
            break;
        }
    }

    public static Set<Annotation> getAnnotations(Class<?> entityClass, PropertyDescriptor descriptor) {
        LinkedHashSet<Annotation> annotations = new LinkedHashSet<Annotation>();
        LinkedHashSet types = new LinkedHashSet();
        Consumer<Annotation[]> annoConsumer = ann -> {
            for (Annotation annotation : ann) {
                if (!types.contains(annotation.getClass())) {
                    annotations.add(annotation);
                }
                types.add(annotation.annotationType());
            }
        };
        Method read = descriptor.getReadMethod();
        Method write = descriptor.getWriteMethod();
        if (read != null) {
            annoConsumer.accept(read.getAnnotations());
        }
        if (write != null) {
            annoConsumer.accept(write.getAnnotations());
        }
        AnnotationUtils.getFiledByDescriptor(entityClass, descriptor).map(AccessibleObject::getAnnotations).ifPresent(annoConsumer);
        return annotations;
    }

    public static <T extends Annotation> T getAnnotation(Class<?> entityClass, PropertyDescriptor descriptor, Class<T> type) {
        Annotation ann = null;
        if (descriptor == null) {
            return null;
        }
        Method read = descriptor.getReadMethod();
        Method write = descriptor.getWriteMethod();
        if (read != null) {
            ann = (Annotation)AnnotationUtils.getAnnotation(read, type);
        }
        if (null == ann && write != null) {
            ann = (Annotation)AnnotationUtils.getAnnotation(write, type);
        }
        if (ann == null) {
            ann = AnnotationUtils.getFiledByDescriptor(entityClass, descriptor).map(f -> f.getAnnotation(type)).orElse(null);
        }
        return (T)ann;
    }

    public static <T extends Annotation> T getAnnotation(Class<?> clazz, Class<T> annotation) {
        T ann = clazz.getAnnotation(annotation);
        while (ann == null && (clazz = clazz.getSuperclass()) != null && clazz != Object.class) {
            ann = clazz.getAnnotation(annotation);
        }
        return ann;
    }

    public static <T extends Annotation> T getAnnotation(Method method, Class<T> annotation) {
        T ann = method.getAnnotation(annotation);
        Class<?> clazz = method.getDeclaringClass();
        while (ann == null && (clazz = clazz.getSuperclass()) != null && clazz != Object.class) {
            try {
                Method suMethod = clazz.getMethod(method.getName(), method.getParameterTypes());
                ann = suMethod.getAnnotation(annotation);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        return ann;
    }
}

