/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.expands.office.excel;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.hswebframework.expands.office.excel.ExcelReaderWrapper;
import org.hswebframework.expands.office.excel.api.poi.POIExcelApi;
import org.hswebframework.expands.office.excel.config.ExcelWriterConfig;
import org.hswebframework.expands.office.excel.config.Header;
import org.hswebframework.expands.office.excel.support.CommonExcelReader;
import org.hswebframework.expands.office.excel.support.CommonExcelWriter;
import org.hswebframework.expands.office.excel.support.template.TemplateExcelWriter4POI;
import org.hswebframework.expands.office.excel.support.template.expression.CommonCellHelper;
import org.hswebframework.expands.office.excel.support.template.expression.GroovyExpressionRunner;
import org.hswebframework.expands.office.excel.wrapper.BeanWrapper;
import org.hswebframework.expands.office.excel.wrapper.HashMapWrapper;
import org.hswebframework.expands.office.excel.wrapper.MultitermSheetWrapper;

public class ExcelIO {
    public static List<Map<String, Object>> read2Map(InputStream inputStream) throws Exception {
        return ExcelIO.read(inputStream, new HashMapWrapper());
    }

    public static List<List<Map<String, Object>>> read2MulMap(InputStream inputStream) throws Exception {
        ExcelReaderWrapper[] wrapper = new HashMapWrapper[]{new HashMapWrapper()};
        return ExcelIO.read(inputStream, wrapper);
    }

    public static <T> List<T> read2Bean(InputStream inputStream, Map<String, String> headerMapper, Class<T> tClass) throws Exception {
        BeanWrapper<T> wrapper = new BeanWrapper<T>();
        wrapper.setType(tClass);
        wrapper.setHeaderNameMapper(headerMapper);
        return ExcelIO.read(inputStream, wrapper);
    }

    public static <T> List<T> read(InputStream inputStream, ExcelReaderWrapper<T> wrapper) throws Exception {
        CommonExcelReader<T> reader = new CommonExcelReader<T>();
        reader.setWrapper(wrapper);
        return reader.readExcel(inputStream);
    }

    public static void read(InputStream inputStream, Map<String, String> headerMapping, final Consumer<OnRow<Map<String, Object>>> consumer) throws Exception {
        CommonExcelReader<Object> reader = new CommonExcelReader<Object>();
        HashMapWrapper wrapper = new HashMapWrapper();
        wrapper.setHeaderNameMapper(headerMapping);
        reader.setWrapper(new MultitermSheetWrapper(new HashMapWrapper[]{wrapper}){

            @Override
            public boolean wrapperDone(final Object instance) {
                final Runnable shutdown = this::shutdown;
                consumer.accept(new OnRow<Map<String, Object>>(){

                    @Override
                    public int getSheet() {
                        return sheet;
                    }

                    @Override
                    public Map<String, Object> getResult() {
                        return (Map)instance;
                    }

                    @Override
                    public void shutdown() {
                        shutdown.run();
                    }
                });
                return false;
            }
        });
        reader.readExcel(inputStream);
    }

    public static void read(InputStream inputStream, Consumer<OnRow<Map<String, Object>>> consumer) throws Exception {
        ExcelIO.read(inputStream, Collections.emptyMap(), consumer);
    }

    public static <T> void read(InputStream inputStream, Map<String, String> headerMapper, final Class<T> tClass, final Consumer<OnRow<T>> consumer) throws Exception {
        CommonExcelReader<Object> reader = new CommonExcelReader<Object>();
        reader.setWrapper(new MultitermSheetWrapper(new BeanWrapper[]{new BeanWrapper<T>(tClass, headerMapper)}){

            @Override
            public boolean wrapperDone(final Object instance) {
                final Runnable shutdown = this::shutdown;
                consumer.accept(new OnRow<T>(){

                    @Override
                    public int getSheet() {
                        return sheet;
                    }

                    @Override
                    public T getResult() {
                        return tClass.cast(instance);
                    }

                    @Override
                    public void shutdown() {
                        shutdown.run();
                    }
                });
                return false;
            }
        });
        reader.readExcel(inputStream);
    }

    public static List<List> read(InputStream inputStream, ExcelReaderWrapper[] wrappers) throws Exception {
        CommonExcelReader<Object> reader = new CommonExcelReader<Object>();
        MultitermSheetWrapper wrapper = new MultitermSheetWrapper(wrappers);
        reader.setWrapper(wrapper);
        reader.readExcel(inputStream);
        return wrapper.getData();
    }

    public static void write(OutputStream outputStream, List<Header> headers, List<Object> dataList) throws Exception {
        ExcelWriterConfig config = new ExcelWriterConfig();
        config.setHeaders(headers);
        config.setDatas(dataList);
        ExcelIO.write(outputStream, config, new ExcelWriterConfig[0]);
    }

    public static void write(OutputStream outputStream, List<Header> headers, List<Object> dataList, String[] merge) throws Exception {
        ExcelWriterConfig config = new ExcelWriterConfig();
        config.setHeaders(headers);
        config.setDatas(dataList);
        config.setMergeColumns(Arrays.asList(merge));
        ExcelIO.write(outputStream, config, new ExcelWriterConfig[0]);
    }

    public static void writeTemplate(InputStream inputStream, OutputStream outputStream, Map<String, Object> var) throws Exception {
        GroovyExpressionRunner runner = new GroovyExpressionRunner();
        runner.setHelper(new CommonCellHelper());
        runner.setData(var);
        TemplateExcelWriter4POI templateExcelWriter4POI = new TemplateExcelWriter4POI(var, outputStream, runner);
        POIExcelApi.getInstance().read(inputStream, templateExcelWriter4POI);
    }

    public static void write(OutputStream outputStream, ExcelWriterConfig config, ExcelWriterConfig ... moreSheet) throws Exception {
        CommonExcelWriter writer = new CommonExcelWriter();
        writer.write(outputStream, config, moreSheet);
    }

    public static interface OnRow<T> {
        public int getSheet();

        public T getResult();

        public void shutdown();
    }
}

