/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.expands.office.excel.api.poi;

import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.hswebframework.expands.office.excel.ExcelApi;
import org.hswebframework.expands.office.excel.api.poi.callback.POIExcelWriterProcessor;
import org.hswebframework.expands.office.excel.config.ExcelReaderCallBack;
import org.hswebframework.expands.office.excel.config.ExcelWriterCallBack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class POIExcelApi
implements ExcelApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final POIExcelApi instance = new POIExcelApi();

    private POIExcelApi() {
    }

    public static POIExcelApi getInstance() {
        return instance;
    }

    @Override
    public void read(InputStream inputStream, ExcelReaderCallBack callBack) throws Exception {
        Workbook wbs = WorkbookFactory.create((InputStream)inputStream);
        int sheetSize = wbs.getNumberOfSheets();
        for (int x = 0; x < sheetSize; ++x) {
            Sheet sheet = wbs.getSheetAt(x);
            int rowNum = sheet.getLastRowNum();
            if (rowNum <= 0) continue;
            Row row = sheet.getRow(0);
            int colNum = row.getPhysicalNumberOfCells();
            for (int i = 0; i <= rowNum; ++i) {
                row = sheet.getRow(i);
                if (row == null) continue;
                for (int j = 0; j < colNum; ++j) {
                    if (callBack.isShutdown()) {
                        return;
                    }
                    Cell cell = row.getCell(j);
                    ExcelReaderCallBack.CellContent cellContent = new ExcelReaderCallBack.CellContent();
                    cellContent.setCellProxy(cell);
                    cellContent.setFirst(j == 0);
                    cellContent.setLast(j == colNum - 1);
                    cellContent.setSheet(x);
                    cellContent.setRow(i);
                    cellContent.setColumn(j);
                    Object value = this.cell2Object(cell);
                    cellContent.setValue(value);
                    callBack.onCell(cellContent);
                }
            }
            callBack.sheetDone(sheet);
        }
        callBack.done(wbs);
    }

    protected Object cell2Object(Cell cell) {
        if (cell == null) {
            return "";
        }
        switch (cell.getCellTypeEnum()) {
            case BOOLEAN: {
                return cell.getBooleanCellValue();
            }
            case NUMERIC: {
                if (POIExcelApi.isCellDateFormatted(cell)) {
                    return cell.getDateCellValue();
                }
                String stringValue = String.valueOf(cell.getNumericCellValue());
                BigDecimal value = new BigDecimal(stringValue);
                if (stringValue.endsWith(".0") || stringValue.endsWith(".00")) {
                    return value.intValue();
                }
                return value;
            }
            case STRING: {
                return cell.getRichStringCellValue().getString();
            }
            case FORMULA: {
                FormulaEvaluator evaluator = cell.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
                CellValue cellValue = evaluator.evaluate(cell);
                switch (cellValue.getCellTypeEnum()) {
                    case BOOLEAN: {
                        return cell.getBooleanCellValue();
                    }
                    case NUMERIC: {
                        if (POIExcelApi.isCellDateFormatted(cell)) {
                            return cell.getDateCellValue();
                        }
                        BigDecimal value = new BigDecimal(cell.getNumericCellValue());
                        if (String.valueOf(value).endsWith(".0") || String.valueOf(value).endsWith(".00")) {
                            return value.intValue();
                        }
                        return value;
                    }
                    case BLANK: {
                        return "";
                    }
                }
                return cellValue.getStringValue();
            }
            case BLANK: {
                return "";
            }
        }
        return cell.getStringCellValue();
    }

    public static boolean isCellDateFormatted(Cell cell) {
        if (cell == null) {
            return false;
        }
        boolean bDate = false;
        double d = cell.getNumericCellValue();
        if (DateUtil.isValidExcelDate((double)d)) {
            CellStyle style = cell.getCellStyle();
            if (style == null) {
                return false;
            }
            short i = style.getDataFormat();
            if (i == 58 || i == 31) {
                return true;
            }
            String f = style.getDataFormatString();
            f = f.replaceAll("[\"|']", "").replaceAll("[\u5e74|\u6708|\u65e5|\u65f6|\u5206|\u79d2|\u6beb\u79d2|\u5fae\u79d2]", "");
            bDate = DateUtil.isADateFormat((int)i, (String)f);
        }
        return bDate;
    }

    @Override
    public void write(OutputStream outputStream, ExcelWriterCallBack callBack, ExcelWriterCallBack ... moreSheet) throws Exception {
        this.logger.info("create workbook");
        XSSFWorkbook workbook = new XSSFWorkbook();
        ArrayList<ExcelWriterCallBack> allSheet = new ArrayList<ExcelWriterCallBack>(Arrays.asList(moreSheet));
        allSheet.add(0, callBack);
        int index = 0;
        this.logger.info("start write sheet,size :" + allSheet.size());
        for (ExcelWriterCallBack writerCallBack : allSheet) {
            POIExcelWriterProcessor processor = new POIExcelWriterProcessor(outputStream, (Workbook)workbook, false);
            processor.setSheetIndex(index++);
            writerCallBack.render(processor);
        }
        workbook.write(outputStream);
    }
}

