/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.expands.office.excel.api.poi.callback;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.hswebframework.expands.office.excel.config.CustomCellStyle;
import org.hswebframework.expands.office.excel.config.CustomColumnStyle;
import org.hswebframework.expands.office.excel.config.CustomRowStyle;
import org.hswebframework.expands.office.excel.config.ExcelWriterCallBack;
import org.hswebframework.expands.office.excel.config.ExcelWriterConfig;
import org.hswebframework.expands.office.excel.config.ExcelWriterProcessor;
import org.hswebframework.expands.office.excel.config.Header;
import org.hswebframework.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonExcelWriterCallBack
implements ExcelWriterCallBack {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ExcelWriterConfig config;
    private final PropertyUtilsBean propertyUtils = BeanUtilsBean.getInstance().getPropertyUtils();
    private ExcelWriterProcessor processor;
    private Sheet sheet;
    private Map<String, CellStyle> cellStyleCache = new ConcurrentHashMap<String, CellStyle>();

    public CommonExcelWriterCallBack(ExcelWriterConfig config) {
        this.config = config;
    }

    @Override
    public void render(ExcelWriterProcessor processor) {
        try {
            this.logger.info("create sheet [{}]", (Object)this.config.getSheetName());
            this.sheet = this.config.getSheetName() != null ? (Sheet)processor.start(this.config.getSheetName()) : (Sheet)processor.start();
            this.processor = processor;
            this.logger.info("sheet [{}] build data ", (Object)this.config.getSheetName());
            this.buildData();
            this.logger.info("sheet [{}]  merge ", (Object)this.config.getSheetName());
            this.startMerge();
            processor.done();
            this.logger.info("sheet [{}]  done ", (Object)this.config.getSheetName());
        }
        catch (Exception e) {
            this.logger.error("writer processor error!", (Throwable)e);
        }
    }

    protected void buildData() {
        Row row;
        List<Header> headers = this.config.getHeaders();
        List<Object> datas = this.config.getDatas();
        for (int y = 0; y < this.config.getStartWith(); ++y) {
            row = (Row)this.processor.nextRow();
            this.initRow(row, y, null);
            for (int i = 0; i < headers.size(); ++i) {
                Object value = this.config.startBefore(y, i);
                Cell cell = (Cell)this.processor.nextCell();
                this.initCell(y, i, cell, headers.get(i).getField(), value);
            }
        }
        this.initHeader();
        for (int x = 0; x < datas.size(); ++x) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("sheet [{}] build data row[{}]", (Object)this.config.getSheetName(), (Object)x);
            }
            row = (Row)this.processor.nextRow();
            Object data = datas.get(x);
            int index = 0;
            for (Header header : headers) {
                Cell cell = (Cell)this.processor.nextCell();
                Object value = null;
                try {
                    value = this.propertyUtils.getProperty(data, header.getField());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (value == null) {
                    value = "";
                }
                this.initCell(x, index, cell, header.getField(), value);
                if (index++ != 0) continue;
                this.initRow(row, row.getRowNum(), header.getField());
            }
        }
    }

    protected void initRow(Row row, int index, String header) {
        CustomRowStyle rowStyle = this.config.getRowStyle(index, header);
        if (rowStyle != null) {
            row.setHeightInPoints((float)rowStyle.getHeight());
        }
    }

    protected void initHeader() {
        this.processor.nextRow();
        List<Header> headers = this.config.getHeaders();
        int x = this.config.getStartWith();
        int len = headers.size();
        for (int y = 0; y < len; ++y) {
            Header header = headers.get(y);
            CustomColumnStyle style = this.config.getColumnStyle(y, header.getTitle());
            if (null != style) {
                this.sheet.setColumnWidth(y, style.getWidth());
            }
            Cell cell = (Cell)this.processor.nextCell();
            this.initCell(x, y, cell, header.getField(), header.getTitle());
            CustomCellStyle titleStyle = header.getStyle();
            if (null == titleStyle) continue;
            CellStyle cacheStyle = this.getStyle(titleStyle);
            cell.setCellStyle(cacheStyle);
        }
    }

    protected void initCell(Cell cell, Object value) {
        cell.setCellValue(String.valueOf(value));
    }

    protected void initCell(int r, int c, Cell cell, String header, Object value) {
        CustomCellStyle style = this.config.getCellStyle(r, c, header, value);
        if (style == null) {
            this.initCell(cell, value);
            return;
        }
        CellStyle cellStyle = this.getStyle(style);
        cell.setCellStyle(cellStyle);
        switch (style.getDataType()) {
            case "date": {
                cell.setCellValue((Date)style.getValue());
                break;
            }
            case "int": {
                cell.setCellValue((double)StringUtils.toInt((Object)style.getValue()));
                break;
            }
            case "double": {
                cell.setCellValue(StringUtils.toDouble((Object)style.getValue()));
                break;
            }
            default: {
                cell.setCellValue(String.valueOf(style.getValue()));
            }
        }
    }

    protected void startMerge() {
        this.prepareMerges();
        List<ExcelWriterConfig.Merge> merges = this.config.getMerges();
        for (ExcelWriterConfig.Merge merge : merges) {
            try {
                this.sheet.addMergedRegion(new CellRangeAddress(merge.getRowFrom() + this.config.getStartWith(), merge.getColTo() + this.config.getStartWith(), merge.getColFrom(), merge.getRowTo()));
            }
            catch (Exception e) {
                this.logger.error("merge column ({}) error", (Object)merge, (Object)e);
            }
        }
    }

    protected void prepareMerges() {
        List<String> list = this.config.getMergeColumns();
        Map cols = this.config.getHeaders().stream().filter(header -> list.contains(header.getField())).collect(Collectors.toMap(Header::getField, this.config.getHeaders()::indexOf, (u, l) -> l, LinkedHashMap::new));
        List<Object> datas = this.config.getDatas();
        ArrayList<String> temp = new ArrayList<String>();
        for (String header2 : cols.keySet()) {
            int index = (Integer)cols.get(header2);
            int lastMergeNumber = 0;
            int countNumber = 0;
            String lastData = null;
            int dataIndex = 0;
            for (Object data : this.config.getDatas()) {
                ++dataIndex;
                String val = null;
                try {
                    val = BeanUtils.getProperty((Object)data, (String)header2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (val == null) {
                    val = "";
                }
                if (index != 0 && !temp.contains(StringUtils.concat((Object[])new Object[]{"c_", index - 1, "_d", dataIndex}))) {
                    lastData = "__$$";
                }
                if (val.equals(lastData) || lastData == null) {
                    ++countNumber;
                    temp.add(StringUtils.concat((Object[])new Object[]{"c_", index, "_d", dataIndex}));
                } else {
                    this.config.addMerge(lastMergeNumber + 1, index, index, countNumber);
                    lastMergeNumber = countNumber++;
                }
                if (datas.indexOf(data) == datas.size() - 1) {
                    this.config.addMerge(lastMergeNumber + 1, index, index, datas.size());
                    temp.add(StringUtils.concat((Object[])new Object[]{"c_", index, "_d", dataIndex}));
                }
                lastData = val;
            }
        }
    }

    private CellStyle getStyle(CustomCellStyle customCellStyle) {
        CellStyle style = this.getStyleFromCache(customCellStyle.getCacheKey());
        Workbook workbook = this.sheet.getWorkbook();
        if (style == null) {
            style = workbook.createCellStyle();
            if (customCellStyle.getFontName() != null || customCellStyle.getFontColor() != 0) {
                Font font = workbook.createFont();
                if (customCellStyle.getFontName() != null) {
                    font.setFontName(customCellStyle.getFontName());
                }
                if (customCellStyle.getFontColor() != 0) {
                    font.setColor(customCellStyle.getFontColor());
                }
                style.setFont(font);
            }
            if (customCellStyle.getBorderTop() != null) {
                style.setBorderTop(BorderStyle.valueOf((short)customCellStyle.getBorderTop().getSize()));
                style.setTopBorderColor(customCellStyle.getBorderTop().getColor());
            }
            if (customCellStyle.getBorderBottom() != null) {
                style.setBorderBottom(BorderStyle.valueOf((short)customCellStyle.getBorderBottom().getSize()));
                style.setBottomBorderColor(customCellStyle.getBorderBottom().getColor());
            }
            if (customCellStyle.getBorderLeft() != null) {
                style.setBorderLeft(BorderStyle.valueOf((short)customCellStyle.getBorderTop().getSize()));
                style.setLeftBorderColor(customCellStyle.getBorderTop().getColor());
            }
            if (customCellStyle.getBorderRight() != null) {
                style.setBorderRight(BorderStyle.valueOf((short)customCellStyle.getBorderTop().getSize()));
                style.setRightBorderColor(customCellStyle.getBorderTop().getColor());
            }
            if (customCellStyle.getFormat() != null) {
                DataFormat dataFormat = workbook.createDataFormat();
                style.setDataFormat(dataFormat.getFormat(customCellStyle.getFormat()));
            }
            style.setAlignment(HorizontalAlignment.forInt((int)customCellStyle.getAlignment()));
            style.setVerticalAlignment(VerticalAlignment.forInt((int)customCellStyle.getVerticalAlignment()));
            this.putStyleFromCache(customCellStyle.getCacheKey(), style);
        }
        return style;
    }

    private void putStyleFromCache(String key, CellStyle cellStyle) {
        this.cellStyleCache.put(key, cellStyle);
    }

    private CellStyle getStyleFromCache(String key) {
        return this.cellStyleCache.get(key);
    }
}

