/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.expands.office.excel.api.poi.callback;

import java.io.OutputStream;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.hswebframework.expands.office.excel.config.ExcelWriterProcessor;

public class POIExcelWriterProcessor
implements ExcelWriterProcessor {
    private OutputStream outputStream;
    private Workbook workbook;
    private Sheet sheet;
    private int sheetIndex = 0;
    private boolean started;
    private boolean done;
    private Row nowRow;
    private Cell nowCell;
    private boolean autoWrite;

    public POIExcelWriterProcessor(OutputStream outputStream, Workbook workbook, boolean autoWrite) {
        this.outputStream = outputStream;
        this.workbook = workbook;
        this.autoWrite = autoWrite;
    }

    @Override
    public <S> S start() throws Exception {
        return this.start("\u8868\u683c" + this.sheetIndex);
    }

    @Override
    public <S> S start(String sheetName) throws Exception {
        if (this.started) {
            throw new NullPointerException("processor is stared!");
        }
        this.sheet = this.workbook.createSheet(sheetName);
        this.started = true;
        return (S)this.sheet;
    }

    @Override
    public <R> R nextRow() {
        int rowNum = this.nowRow != null ? this.nowRow.getRowNum() + 1 : 0;
        this.nowRow = this.sheet.createRow(rowNum);
        this.nowCell = null;
        return (R)this.nowRow;
    }

    @Override
    public <C> C nextCell() {
        int cellNum = this.nowCell != null ? this.nowCell.getColumnIndex() + 1 : 0;
        this.nowCell = this.nowRow.createCell(cellNum);
        return (C)this.nowCell;
    }

    @Override
    public void done() throws Exception {
        if (this.done) {
            throw new NullPointerException("processor is done");
        }
        if (this.autoWrite) {
            this.workbook.write(this.outputStream);
        }
        this.done = true;
    }

    public int getSheetIndex() {
        return this.sheetIndex;
    }

    public void setSheetIndex(int sheetIndex) {
        this.sheetIndex = sheetIndex;
    }
}

