/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.expands.office.excel.config;

import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.hswebframework.expands.office.excel.config.CustomCellStyle;
import org.hswebframework.expands.office.excel.config.CustomColumnStyle;
import org.hswebframework.expands.office.excel.config.CustomRowStyle;
import org.hswebframework.expands.office.excel.config.Header;

public class ExcelWriterConfig {
    private String sheetName;
    private int startWith = 0;
    private List<String> mergeColumns = new LinkedList<String>();
    private List<Merge> merges = new LinkedList<Merge>();
    private List<Header> headers = new LinkedList<Header>();
    private List<Object> datas = new LinkedList<Object>();
    private CustomCellStyle cellStyle = new CustomCellStyle();

    public ExcelWriterConfig addHeader(String header, String field) {
        this.addHeader(new Header(header, field));
        return this;
    }

    public ExcelWriterConfig addHeader(Header header) {
        header.setSort(this.headers.size());
        this.headers.add(header);
        return this;
    }

    public ExcelWriterConfig addData(Object data) {
        this.datas.add(data);
        return this;
    }

    public ExcelWriterConfig addAll(List<Object> data) {
        this.datas.addAll(data);
        return this;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public int getStartWith() {
        return this.startWith;
    }

    public void setStartWith(int startWith) {
        this.startWith = startWith;
    }

    public ExcelWriterConfig mergeColumn(String ... column) {
        this.mergeColumns.addAll(Arrays.asList(column));
        return this;
    }

    public List<String> getMergeColumns() {
        return this.mergeColumns;
    }

    public void setMergeColumns(List<String> mergeColumns) {
        this.mergeColumns = mergeColumns;
    }

    public List<Merge> getMerges() {
        return this.merges;
    }

    public void setMerges(List<Merge> merges) {
        this.merges = merges;
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public void setHeaders(List<Header> headers) {
        for (int i = 0; i < headers.size(); ++i) {
            Header header = headers.get(i);
            if (header.getSort() != -1) continue;
            header.setSort(i);
        }
        headers.sort(Header::compareTo);
        this.headers = headers;
    }

    public List<Object> getDatas() {
        return this.datas;
    }

    public void setDatas(List<Object> datas) {
        this.datas = datas;
    }

    public void addMerge(int rowFrom, int colFrom, int rowTo, int colTo) {
        this.addMerge(new Merge(rowFrom, colFrom, rowTo, colTo));
    }

    public void addMerge(Merge merge) {
        if (!this.merges.contains(merge)) {
            this.merges.add(merge);
        }
    }

    public ExcelWriterConfig() {
        this.cellStyle.setAlignment(HorizontalAlignment.CENTER.getCode());
        this.cellStyle.setVerticalAlignment(VerticalAlignment.CENTER.getCode());
        CustomCellStyle.Border border = new CustomCellStyle.Border(1, HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        this.cellStyle.setBorderLeft(border);
        this.cellStyle.setBorderRight(border);
        this.cellStyle.setBorderBottom(border);
        this.cellStyle.setBorderTop(border);
    }

    public Object startBefore(int row, int column) {
        return "";
    }

    public CustomCellStyle getCellStyle(int row, int column, String header, Object value) {
        this.cellStyle.setFormat("");
        if (value == null) {
            this.cellStyle.setDataType("string");
        } else if (value instanceof Integer) {
            this.cellStyle.setDataType("int");
        } else if (value instanceof Number) {
            this.cellStyle.setDataType("double");
        } else if (value instanceof Date) {
            this.cellStyle.setDataType("date");
            this.cellStyle.setFormat("yyyy-MM-dd");
        } else {
            this.cellStyle.setDataType("string");
        }
        this.cellStyle.setValue(value);
        return this.cellStyle;
    }

    public CustomColumnStyle getColumnStyle(int column, String header) {
        return null;
    }

    public CustomRowStyle getRowStyle(int row, String header) {
        return null;
    }

    public class Merge {
        private int rowFrom;
        private int colFrom;
        private int rowTo;
        private int colTo;

        public boolean equals(Object obj) {
            if (obj instanceof Merge) {
                Merge m = (Merge)obj;
                return m.getColFrom() == this.getColFrom() && m.getColTo() == this.getColTo() && m.getRowFrom() == this.getRowFrom() && m.getRowTo() == this.getRowTo();
            }
            return super.equals(obj);
        }

        public Merge(int rowFrom, int colFrom, int rowTo, int colTo) {
            this.rowFrom = rowFrom;
            this.colFrom = colFrom;
            this.rowTo = rowTo;
            this.colTo = colTo;
        }

        public int getRowFrom() {
            return this.rowFrom;
        }

        public void setRowFrom(int rowFrom) {
            this.rowFrom = rowFrom;
        }

        public int getColFrom() {
            return this.colFrom;
        }

        public void setColFrom(int colFrom) {
            this.colFrom = colFrom;
        }

        public int getRowTo() {
            return this.rowTo;
        }

        public void setRowTo(int rowTo) {
            this.rowTo = rowTo;
        }

        public int getColTo() {
            return this.colTo;
        }

        public void setColTo(int colTo) {
            this.colTo = colTo;
        }

        public String toString() {
            return "Merge{rowFrom=" + this.rowFrom + ", colFrom=" + this.colFrom + ", rowTo=" + this.rowTo + ", colTo=" + this.colTo + '}';
        }
    }
}

