/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.expands.office.excel.support;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.hswebframework.expands.office.excel.ExcelApi;
import org.hswebframework.expands.office.excel.ExcelReader;
import org.hswebframework.expands.office.excel.ExcelReaderWrapper;
import org.hswebframework.expands.office.excel.api.poi.POIExcelApi;
import org.hswebframework.expands.office.excel.config.AbstractExcelReaderCallBack;
import org.hswebframework.expands.office.excel.config.ExcelReaderCallBack;

public abstract class AbstractExcelReader<T>
implements ExcelReader<T> {
    protected ExcelApi api = POIExcelApi.getInstance();

    public abstract ExcelReaderWrapper<T> getWrapper();

    @Override
    public List<T> readExcel(InputStream inputStream) throws Exception {
        final ArrayList dataList = new ArrayList();
        AbstractExcelReaderCallBack callBack = new AbstractExcelReaderCallBack(){
            List<String> header = new LinkedList<String>();
            List<ExcelReaderCallBack.CellContent> temp = new LinkedList<ExcelReaderCallBack.CellContent>();
            private int sheet = 0;

            @Override
            public void onCell(ExcelReaderCallBack.CellContent content) throws Exception {
                if (content.getSheet() != this.sheet) {
                    this.header.clear();
                    this.temp.clear();
                    this.sheet = content.getSheet();
                }
                if (AbstractExcelReader.this.getWrapper().isShutdown()) {
                    this.shutdown();
                    return;
                }
                boolean isHeader = AbstractExcelReader.this.isHeader(content, this.header);
                if (isHeader) {
                    this.header.add(String.valueOf(content.getValue()));
                } else if (this.header.size() != 0) {
                    AbstractExcelReader.this.getWrapper().setup(this.header, this.sheet);
                    if (AbstractExcelReader.this.getWrapper().isShutdown()) {
                        this.shutdown();
                        return;
                    }
                    this.temp.add(content);
                    AbstractExcelReader.this.getWrapper().setup(this.header, this.sheet);
                    if (AbstractExcelReader.this.getWrapper().isShutdown()) {
                        this.shutdown();
                        return;
                    }
                    if (content.isLast()) {
                        Object val = AbstractExcelReader.this.wrapperRow(this.header, this.temp, this.sheet);
                        if (null != val) {
                            dataList.add(val);
                        }
                        this.temp.clear();
                    }
                }
            }
        };
        this.api.read(inputStream, callBack);
        return dataList;
    }

    protected T wrapperRow(List<String> headers, List<ExcelReaderCallBack.CellContent> contents, int sheet) throws Exception {
        T instance = this.getWrapper().newInstance(sheet);
        int len = contents.size();
        for (int i = 0; i < len; ++i) {
            String header = null;
            if (headers.size() >= i) {
                header = headers.get(i);
            }
            this.getWrapper().wrapper(instance, header, contents.get(i).getValue());
        }
        return (T)(this.getWrapper().wrapperDone(instance) ? instance : null);
    }

    protected boolean isHeader(ExcelReaderCallBack.CellContent content, List<String> header) {
        return content.getRow() == 0;
    }
}

