/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.expands.office.excel.support.template;

import java.io.OutputStream;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.hswebframework.expands.office.excel.config.ExcelReaderCallBack;
import org.hswebframework.expands.office.excel.support.template.expression.ExpressionRunner;
import org.hswebframework.utils.StringUtils;

public class TemplateExcelWriter4POI
implements ExcelReaderCallBack {
    protected Object data;
    protected OutputStream out;
    private static final Pattern EXPRESSION_PATTERN = StringUtils.compileRegex((String)"(?<=\\$\\{)(.+?)(?=\\})");
    private ExpressionRunner runner;

    public TemplateExcelWriter4POI(Object data, OutputStream out, ExpressionRunner runner) throws Exception {
        if (data == null || out == null) {
            throw new NullPointerException("data or OutputStream can not be null!");
        }
        this.data = data;
        this.out = out;
        this.runner = runner;
    }

    @Override
    public void onCell(ExcelReaderCallBack.CellContent content) throws Exception {
        Cell cell = (Cell)content.getCellProxy();
        if (cell == null) {
            return;
        }
        Object value = content.getValue();
        if (value instanceof String) {
            String temp = value.toString();
            Matcher matcher = EXPRESSION_PATTERN.matcher(temp);
            while (matcher.find()) {
                String group = matcher.group();
                this.runner.pushExpression(cell, group);
            }
        }
    }

    protected void putValue2Cell(Cell cell, Object value) {
        if (value == null) {
            cell.setCellValue("");
        } else if (value instanceof Number) {
            cell.setCellValue(StringUtils.toDouble((Object)value));
        } else if (value instanceof Date) {
            cell.setCellValue((Date)value);
        } else {
            cell.setCellValue(value.toString());
        }
    }

    protected Object getValueFromExpression(String expression) {
        try {
            return BeanUtils.getProperty((Object)this.data, (String)expression);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void sheetDone(Object sheet) throws Exception {
        try {
            this.runner.getHelper().setSheet((Sheet)sheet);
            this.runner.run();
            this.runner.reset();
        }
        catch (Throwable throwable) {
            throw new Exception(throwable);
        }
    }

    @Override
    public void done(Object workBook) throws Exception {
        Workbook wb = (Workbook)workBook;
        wb.write(this.out);
    }
}

