/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.expands.office.excel.support.template.expression;

import java.util.Date;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.hswebframework.expands.office.excel.support.template.expression.CellHelper;
import org.hswebframework.utils.StringUtils;

public class CommonCellHelper
implements CellHelper {
    private Sheet sheet;
    private Row nowRow;

    @Override
    public void setSheet(Sheet sheet) {
        this.sheet = sheet;
        this.nowRow = null;
    }

    @Override
    public void initCell(Object value, Cell cell) {
        this.initCellValue(cell, value);
    }

    @Override
    public void nextCell(Object value, Cell cell) {
        int nowColumn = cell.getColumnIndex();
        Cell realCell = this.nowRow.getCell(nowColumn);
        if (realCell == null) {
            realCell = this.nowRow.createCell(nowColumn);
        }
        realCell.setCellStyle(cell.getCellStyle());
        this.initCellValue(realCell, value);
    }

    @Override
    public void nextRow(Cell cell) {
        if (this.nowRow == null) {
            this.nowRow = cell.getRow();
        } else {
            int rowNum = this.nowRow.getRowNum() + 1;
            this.sheet.shiftRows(rowNum, this.sheet.getLastRowNum(), 1, true, false);
            Row tmp = this.sheet.createRow(rowNum);
            tmp.setHeight(this.nowRow.getHeight());
            tmp.setHeightInPoints(this.nowRow.getHeightInPoints());
            this.nowRow = tmp;
        }
    }

    protected void initCellValue(Cell cell, Object value) {
        if (value == null) {
            cell.setCellValue("");
            return;
        }
        if (value instanceof Number) {
            cell.setCellValue(StringUtils.toDouble((Object)value));
        } else if (value instanceof Date) {
            cell.setCellValue((Date)value);
        } else {
            cell.setCellValue(String.valueOf(value));
        }
    }
}

