/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.expands.office.excel.support.template.expression;

import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.hswebframework.expands.office.excel.support.template.expression.CellHelper;
import org.hswebframework.expands.office.excel.support.template.expression.ExpressionRunner;
import org.hswebframework.expands.script.engine.DynamicScriptEngine;
import org.hswebframework.expands.script.engine.DynamicScriptEngineFactory;
import org.hswebframework.expands.script.engine.ExecuteResult;
import org.hswebframework.utils.StringUtils;

public class GroovyExpressionRunner
implements ExpressionRunner {
    private Map<String, Object> root = new HashMap<String, Object>();
    private StringBuilder builder = new StringBuilder();
    protected CellHelper helper;
    private int cellNumber = 0;
    private int each_flag = 0;

    @Override
    public void setData(Map<String, Object> data) {
        this.root.putAll(data);
    }

    @Override
    public void setHelper(CellHelper helper) {
        this.helper = helper;
    }

    @Override
    public CellHelper getHelper() {
        return this.helper;
    }

    @Override
    public void pushExpression(Cell cell, String expression) {
        ++this.cellNumber;
        String cellName = "cell_" + this.cellNumber;
        this.root.put(cellName, cell);
        if (expression.startsWith("for(")) {
            ++this.each_flag;
            this.builder.append(expression).append("{\n");
            this.builder.append("\t_helper.nextRow(").append(cellName).append(");").append("\n");
        } else if (expression.startsWith("/for")) {
            if (this.each_flag > 0) {
                --this.each_flag;
            }
            this.builder.append("}").append("\n");
        } else if (expression.startsWith("def")) {
            this.builder.append(expression).append(";\n");
            if (this.each_flag <= 0) {
                this.builder.append("\t_helper.initCell(").append("''").append(",").append(cellName).append(");").append("\n");
            }
        } else if (this.each_flag > 0) {
            this.builder.append("\t_helper.nextCell(").append(expression).append(",").append(cellName).append(");").append("\n");
        } else {
            this.builder.append("\t_helper.initCell(").append(expression).append(",").append(cellName).append(");").append("\n");
        }
    }

    @Override
    public void run() throws Throwable {
        ExecuteResult executeResult;
        DynamicScriptEngine engine = DynamicScriptEngineFactory.getEngine((String)"groovy");
        this.root.put("_helper", this.helper);
        String script_id = StringUtils.concat((Object[])new Object[]{"excel_expression_", this.builder.hashCode()});
        if (!engine.compiled(script_id)) {
            engine.compile(script_id, this.builder.toString());
        }
        if ((executeResult = engine.execute(script_id, this.root)).getException() != null) {
            throw executeResult.getException();
        }
    }

    @Override
    public void reset() {
        this.cellNumber = 0;
        this.each_flag = 0;
        this.builder = new StringBuilder();
    }
}

