/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.expands.office.excel.support.template.reader;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.hswebframework.expands.office.excel.config.AbstractExcelReaderCallBack;
import org.hswebframework.expands.office.excel.config.ExcelReaderCallBack;
import org.hswebframework.expands.office.excel.support.CommonExcelReader;

public class TemplateExcelReader<T>
extends CommonExcelReader<T> {
    private InputStream template;
    private List<List<Expression>> templateInfo = new ArrayList<List<Expression>>();

    protected void parseConfig() throws Exception {
        this.api.read(this.template, new AbstractExcelReaderCallBack(){
            int nowRow = -1;
            List<Expression> tmp = null;

            @Override
            public void onCell(ExcelReaderCallBack.CellContent content) throws Exception {
                if (this.nowRow != content.getRow()) {
                    this.nowRow = content.getRow();
                    if (this.tmp != null) {
                        TemplateExcelReader.this.templateInfo.add(this.tmp);
                    }
                    this.tmp = new ArrayList<Expression>();
                }
                Expression expression = new Expression();
                expression.setText(String.valueOf(content.getValue()));
                expression.setColumn(content.getColumn());
                expression.setRow(content.getRow());
                this.tmp.add(expression);
            }

            @Override
            public void done(Object workBook) {
                TemplateExcelReader.this.templateInfo.add(this.tmp);
            }
        });
    }

    public void setTemplate(InputStream template) {
        this.template = template;
    }

    public static class Expression {
        private String text;
        private int row;
        private int column;

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public int getRow() {
            return this.row;
        }

        public void setRow(int row) {
            this.row = row;
        }

        public int getColumn() {
            return this.column;
        }

        public void setColumn(int column) {
            this.column = column;
        }

        public String toString() {
            return "{text='" + this.text + '\'' + ", row=" + this.row + ", column=" + this.column + '}';
        }

        static enum TYPE {
            M,
            F,
            E,
            LIST;

        }
    }
}

