/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.expands.office.word.support.template;

import java.util.List;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.hswebframework.expands.office.word.config.WordReaderCallBack;

public abstract class DOCXStringReader
implements WordReaderCallBack {
    public abstract void readLine(String var1);

    @Override
    public void onParagraph(Object par) {
        XWPFParagraph paragraph = (XWPFParagraph)par;
        String text = this.getParagraphText(paragraph);
        this.readLine(text);
    }

    @Override
    public void onTable(Object t) {
        XWPFTable table = (XWPFTable)t;
        for (XWPFTableRow xwpfTableRow : table.getRows()) {
            for (XWPFTableCell xwpfTableCell : xwpfTableRow.getTableCells()) {
                StringBuilder builder = new StringBuilder();
                for (XWPFParagraph xwpfParagraph : xwpfTableCell.getParagraphs()) {
                    String text = this.getParagraphText(xwpfParagraph);
                    builder.append(text);
                }
                this.readLine(builder.toString());
            }
        }
    }

    @Override
    public void done(Object document) throws Exception {
    }

    protected String getParagraphText(XWPFParagraph paragraph) {
        return this.getRunText(paragraph.getRuns());
    }

    protected String getRunText(List<XWPFRun> xwpfRuns) {
        StringBuilder builder = new StringBuilder();
        for (XWPFRun run : xwpfRuns) {
            builder.append(run.toString());
        }
        return builder.toString();
    }
}

