/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.expands.office.word.support.template;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hswebframework.expands.office.word.api.poi.POIWordApi4Docx;
import org.hswebframework.expands.office.word.support.template.DOCXStringReader;
import org.hswebframework.utils.StringUtils;

public class DOCXTemplateReader {
    private InputStream templateInput;
    private InputStream sourceInput;
    private StringBuilder template = new StringBuilder();
    private StringBuilder source = new StringBuilder();

    public DOCXTemplateReader(InputStream templateInput, InputStream sourceInput) throws Exception {
        this.templateInput = templateInput;
        this.sourceInput = sourceInput;
        this.initTemplate();
    }

    protected String randomChar(int l) {
        char[] cs = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] str = new char[l];
        Random random = new Random();
        for (int i = 0; i < l; ++i) {
            str[i] = cs[random.nextInt(cs.length)];
        }
        return new String(str);
    }

    protected void initTemplate() throws Exception {
        final ArrayList appendStr = new ArrayList();
        POIWordApi4Docx.getInstance().read(this.templateInput, new DOCXStringReader(){

            @Override
            public void readLine(String text) {
                if (StringUtils.isNullOrEmpty((Object)text)) {
                    return;
                }
                String str = DOCXTemplateReader.this.randomChar(5);
                appendStr.add(str);
                DOCXTemplateReader.this.template.append(str).append(String.valueOf(text.trim()).replace("\n", "")).append(str);
            }
        });
        POIWordApi4Docx.getInstance().read(this.sourceInput, new DOCXStringReader(){
            int i = 0;

            @Override
            public void readLine(String text) {
                if (StringUtils.isNullOrEmpty((Object)text)) {
                    return;
                }
                String str = "";
                if (appendStr.size() > this.i) {
                    str = (String)appendStr.get(this.i++);
                }
                DOCXTemplateReader.this.source.append(str).append(String.valueOf(text.trim()).replace("\n", "")).append(str);
            }
        });
    }

    public List<Map<String, Object>> read() {
        return DOCXTemplateReader.text2object(this.source.toString(), this.template.toString());
    }

    public static final List<Map<String, Object>> text2object(String txt, String template) {
        ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>();
        Pattern prepared = Pattern.compile("(?<=\\$\\{)(.+?)(?=\\})");
        Matcher matcher = prepared.matcher(template);
        ArrayList<ExpressInfo> filed = new ArrayList<ExpressInfo>();
        while (matcher.find()) {
            String group = matcher.group();
            String express = StringUtils.concat((Object[])new Object[]{"${", group, "}"});
            int index = template.indexOf(express);
            int express_end = index + express.length();
            String endOf = "\\s";
            String startOf = "";
            if (express_end + 5 < template.length()) {
                endOf = template.substring(express_end, express_end + 5);
            }
            if (endOf.contains("${")) {
                endOf = " ";
            }
            if (index > 5) {
                startOf = template.substring(index - 5, index);
            }
            String pat = StringUtils.concat((Object[])new Object[]{"(?<=", startOf, ")(.*?)(?=", endOf, ")"});
            Pattern pattern = Pattern.compile(pat);
            ExpressInfo info = new ExpressInfo();
            info.setField(group);
            info.setPattern(pattern);
            filed.add(info);
        }
        for (ExpressInfo info : filed) {
            HashMap<String, String> data = new HashMap<String, String>();
            datas.add(data);
            Pattern pattern = info.getPattern();
            Matcher prepared_matcher = pattern.matcher(txt);
            if (!prepared_matcher.find()) continue;
            data.put(info.field, prepared_matcher.group());
        }
        return datas;
    }

    protected static class ExpressInfo {
        private String field;
        private Pattern pattern;

        protected ExpressInfo() {
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public void setPattern(Pattern pattern) {
            this.pattern = pattern;
        }
    }
}

