/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.expands.office.word.support.template;

import java.io.OutputStream;
import java.util.List;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.hswebframework.expands.office.word.config.WordReaderCallBack;
import org.hswebframework.expands.office.word.support.template.expression.ExpressionRunner;

public class DOCXTemplateWriter
implements WordReaderCallBack {
    private OutputStream outputStream;
    private ExpressionRunner runner;

    public DOCXTemplateWriter(OutputStream outputStream, ExpressionRunner runner) {
        this.outputStream = outputStream;
        this.runner = runner;
    }

    @Override
    public void onParagraph(Object par) {
        XWPFParagraph paragraph = (XWPFParagraph)par;
        String text = this.getParagraphText(paragraph);
        this.runner.pushExpression(text, paragraph);
    }

    @Override
    public void onTable(Object t) {
        XWPFTable table = (XWPFTable)t;
        for (XWPFTableRow xwpfTableRow : table.getRows()) {
            for (XWPFTableCell xwpfTableCell : xwpfTableRow.getTableCells()) {
                for (XWPFParagraph xwpfParagraph : xwpfTableCell.getParagraphs()) {
                    String text = this.getParagraphText(xwpfParagraph);
                    this.runner.pushExpression(text, xwpfTableCell, xwpfParagraph);
                }
            }
        }
    }

    protected String getParagraphText(XWPFParagraph paragraph) {
        return this.getRunText(paragraph.getRuns());
    }

    protected String getRunText(List<XWPFRun> xwpfRuns) {
        StringBuilder builder = new StringBuilder();
        for (XWPFRun run : xwpfRuns) {
            builder.append(run.toString());
        }
        return builder.toString();
    }

    @Override
    public void done(Object document) throws Exception {
        try {
            this.runner.run();
        }
        catch (Throwable throwable) {
            throw new Exception(throwable);
        }
        XWPFDocument docx = (XWPFDocument)document;
        docx.write(this.outputStream);
    }
}

