/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.expands.office.word.support.template.expression;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.hswebframework.expands.office.word.support.template.expression.ExpressionRunner;
import org.hswebframework.expands.office.word.support.template.expression.WordHelper;
import org.hswebframework.expands.office.word.support.template.expression.helper.ParagraphHelper;
import org.hswebframework.expands.office.word.support.template.expression.helper.TableHelper;
import org.hswebframework.expands.script.engine.DynamicScriptEngine;
import org.hswebframework.expands.script.engine.DynamicScriptEngineFactory;
import org.hswebframework.expands.script.engine.ExecuteResult;
import org.hswebframework.utils.ListUtils;
import org.hswebframework.utils.StringUtils;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;

public class GroovyExpressionRunner
implements ExpressionRunner {
    private int flag = 0;
    private int eachFlag = 0;
    private int t_eachFlag = 0;
    private int ifFlag = 0;
    private StringBuilder script = new StringBuilder();
    private Map<String, Object> vars = new HashMap<String, Object>();
    private WordHelper helper = new ParagraphHelper();
    private WordHelper cellHelper = new TableHelper();

    protected int nextFlag() {
        return ++this.flag;
    }

    @Override
    public void pushExpression(String expression, Object paragraph) {
        XWPFParagraph xwpfParagraph = (XWPFParagraph)paragraph;
        List<ExpressInfo> infoList = this.parseExpression(xwpfParagraph);
        if (infoList.size() == 0) {
            return;
        }
        String p_id = "paragraph_" + this.nextFlag();
        String info_id = "infoList_" + this.nextFlag();
        this.vars.put(info_id, infoList);
        this.vars.put(p_id, paragraph);
        for (ExpressInfo expressInfo : infoList) {
            String s = expressInfo.getExpress();
            s = s.substring(2);
            if ((s = s.substring(0, s.length() - 1).trim()).startsWith("if")) {
                ++this.ifFlag;
                this.script.append(s).append("{\n");
                expressInfo.setKeyWord(true);
                continue;
            }
            if (s.startsWith("/if")) {
                --this.ifFlag;
                this.script.append("}\n");
                expressInfo.setKeyWord(true);
                continue;
            }
            String exp_id = "expression_" + this.nextFlag();
            this.vars.put(exp_id, expressInfo);
            this.script.append(StringUtils.concat((Object[])new Object[]{exp_id, ".setValue(", s, ");\n"}));
        }
        this.script.append(StringUtils.concat((Object[])new Object[]{"_helper.init(", info_id, ",", p_id, ");\n"}));
    }

    protected List<ExpressInfo> parseExpression(XWPFParagraph paragraph) {
        LinkedList<ExpressInfo> expressInfos = new LinkedList<ExpressInfo>();
        List runs = paragraph.getRuns();
        boolean inExpress = false;
        ExpressInfo temp = null;
        int index = 0;
        for (int i = 0; i < runs.size(); ++i) {
            XWPFRun run = (XWPFRun)runs.get(i);
            CTR ctr = run.getCTR();
            for (CTText ctText : ctr.getTList()) {
                String[] t;
                String text = ctText.getStringValue();
                boolean now = false;
                if (text.contains("$")) {
                    inExpress = true;
                    temp = new ExpressInfo();
                    temp.setStartWith(index);
                    temp.setRun(run);
                    t = text.split("\\$");
                    if (t.length > 1) {
                        temp.push("$" + t[1]);
                    } else {
                        temp.push("$");
                    }
                    now = true;
                }
                if (inExpress && text.contains("}")) {
                    temp.setEndWith(index);
                    if (now) {
                        temp.push("}");
                    } else {
                        t = text.split("\\}");
                        if (t.length > 0) {
                            temp.push(t[0] + "}");
                        } else {
                            temp.push("}");
                        }
                    }
                    expressInfos.add(temp);
                    now = true;
                    temp = null;
                    inExpress = false;
                }
                if (inExpress && !now) {
                    temp.push(text);
                }
                ++index;
            }
        }
        return expressInfos;
    }

    protected List<String> parseExpression(String expression) {
        String[] tmp = expression.split("\\$\\{");
        ArrayList<String> strList = new ArrayList<String>();
        for (String s : tmp) {
            if (!(s = s.replace("\uff5b", "{").replace("\uff5d", "}")).contains("}")) {
                if (StringUtils.isNullOrEmpty((Object)s)) continue;
                strList.add(StringUtils.concat((Object[])new Object[]{"\"", s.replace("\"", "\\\""), "\""}));
                continue;
            }
            String[] temp2 = s.split("\\}");
            if (temp2.length == 0) continue;
            strList.add(temp2[0].trim().replace("\u201d", "\"").replace("\u201c", "\"").replace("\u2018", "'").replace("\u2019", "'"));
            if (temp2.length <= 1) continue;
            strList.add(StringUtils.concat((Object[])new Object[]{"\"", temp2[1].replace("\"", "\\\""), "\""}));
        }
        return strList;
    }

    @Override
    public void pushExpression(String expression, Object cell, Object paragraph) {
        XWPFTableCell cell1 = (XWPFTableCell)cell;
        XWPFParagraph xwpfParagraph = (XWPFParagraph)paragraph;
        String p_id = "paragraph_" + this.nextFlag();
        String c_id = "cell_" + this.nextFlag();
        List<String> expressionList = this.parseExpression(expression);
        this.vars.put(p_id, paragraph);
        this.vars.put(c_id, cell);
        ArrayList<String> temp = new ArrayList<String>();
        boolean endEach = false;
        for (String s : expressionList) {
            if (s.startsWith("for")) {
                ++this.t_eachFlag;
                this.script.append(s).append("{\n");
                this.script.append(StringUtils.concat((Object[])new Object[]{"_cellHelper.nextRow(", c_id, ");\n"}));
                continue;
            }
            if (s.startsWith("/for")) {
                --this.t_eachFlag;
                this.script.append(StringUtils.concat((Object[])new Object[]{"_cellHelper.nextCell(", c_id, ",", ListUtils.toString((Object[])temp.toArray()), ");\n"}));
                endEach = true;
                this.script.append("}\n");
                continue;
            }
            temp.add(s);
        }
        if (this.t_eachFlag > 0) {
            this.script.append(StringUtils.concat((Object[])new Object[]{"_cellHelper.nextCell(", c_id, ",", ListUtils.toString((Object[])temp.toArray()), ");\n"}));
        } else if (!endEach) {
            this.script.append(StringUtils.concat((Object[])new Object[]{"_helper.initParaGraph(", p_id, ",", ListUtils.toString((Object[])temp.toArray()), ");\n"}));
        }
    }

    @Override
    public void setVar(Map<String, Object> var) {
        this.vars.putAll(var);
    }

    @Override
    public void run() throws Throwable {
        ExecuteResult result;
        this.vars.put("_helper", this.helper);
        this.vars.put("_cellHelper", this.cellHelper);
        DynamicScriptEngine engine = DynamicScriptEngineFactory.getEngine((String)"groovy");
        String id = "word.runner." + this.script.hashCode();
        if (!engine.compiled(id)) {
            engine.compile(id, this.script.toString());
        }
        if ((result = engine.execute(id, this.vars)).getException() != null) {
            throw result.getException();
        }
    }

    public static class ExpressInfo {
        private String express = "";
        private XWPFRun run;
        private int startWith;
        private int endWith;
        private Object value;
        private boolean keyWord;

        public boolean isKeyWord() {
            return this.keyWord;
        }

        public void setKeyWord(boolean keyWord) {
            this.keyWord = keyWord;
        }

        public void push(String str) {
            if ((str = str.replace("\u201d", "\"").replace("\u201c", "\"").replace("\u2018", "'").replace("\u2019", "'")).equals("}") && this.express.endsWith("}")) {
                return;
            }
            this.express = this.express + str;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public XWPFRun getRun() {
            return this.run;
        }

        public void setRun(XWPFRun run) {
            this.run = run;
        }

        public String getExpress() {
            return this.express;
        }

        public void setExpress(String express) {
            this.express = express;
        }

        public int getStartWith() {
            return this.startWith;
        }

        public void setStartWith(int startWith) {
            this.startWith = startWith;
        }

        public int getEndWith() {
            return this.endWith;
        }

        public void setEndWith(int endWith) {
            this.endWith = endWith;
        }

        public String toString() {
            return "ExpressInfo{express='" + this.express + '\'' + ", run=" + this.run + ", startWith=" + this.startWith + ", endWith=" + this.endWith + ", value=" + this.value + '}';
        }
    }
}

