/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.expands.office.word.support.template.expression.helper;

import java.util.List;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.hswebframework.expands.office.word.support.template.expression.GroovyExpressionRunner;
import org.hswebframework.expands.office.word.support.template.expression.WordHelper;
import org.hswebframework.utils.StringUtils;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;

public class ParagraphHelper
implements WordHelper {
    private XWPFParagraph newPTemp = null;

    public void init(List<GroovyExpressionRunner.ExpressInfo> infoList, XWPFParagraph paragraph) {
        for (GroovyExpressionRunner.ExpressInfo expressInfo : infoList) {
            int cindex = 0;
            int rindex = 0;
            for (XWPFRun run : paragraph.getRuns()) {
                for (CTText ctText : run.getCTR().getTList()) {
                    if (cindex > expressInfo.getStartWith() && cindex < expressInfo.getEndWith() + 1) {
                        ctText.setStringValue("");
                    }
                    ++cindex;
                }
                ++rindex;
            }
            XWPFRun run = expressInfo.getRun();
            boolean index = false;
            for (CTText ctText : run.getCTR().getTList()) {
                if (!index && !expressInfo.isKeyWord()) {
                    ctText.setStringValue(String.valueOf(expressInfo.getValue()));
                    continue;
                }
                ctText.setStringValue("");
            }
        }
    }

    public void initParaGraph(XWPFParagraph paragraph, Object ... params) {
        if (params == null) {
            return;
        }
        int index = 0;
        for (XWPFRun run : paragraph.getRuns()) {
            for (CTText ctText : run.getCTR().getTList()) {
                if (index++ == 0) {
                    ctText.setStringValue(StringUtils.concat((Object[])params));
                    continue;
                }
                ctText.setStringValue("");
            }
        }
    }

    public void newParaGraph(XWPFParagraph paragraph, Object ... params) {
        this.initParaGraph(paragraph, params);
    }

    @Override
    public void reset() {
    }
}

