/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.expands.security.rsa;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import org.hswebframework.expands.security.rsa.RSAPrivateEncrypt;
import org.hswebframework.expands.security.rsa.RSAPublicEncrypt;

public class RSAEncrypt {
    RSAPublicKey publicKey;
    RSAPrivateKey privateKey;
    int keySize;

    private RSAEncrypt(int keySize) {
        this.keySize = keySize;
    }

    protected void createKey() {
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
            keyPairGen.initialize(this.keySize);
            KeyPair keyPair = keyPairGen.generateKeyPair();
            this.publicKey = (RSAPublicKey)keyPair.getPublic();
            this.privateKey = (RSAPrivateKey)keyPair.getPrivate();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public RSAPublicEncrypt publicEncrypt() {
        if (this.publicKey == null) {
            this.createKey();
        }
        return new RSAPublicEncrypt(this.publicKey);
    }

    public RSAPrivateEncrypt privateEncrypt() {
        if (this.privateKey == null) {
            this.createKey();
        }
        return new RSAPrivateEncrypt(this.privateKey);
    }

    public RSAPublicEncrypt publicEncrypt(String key) {
        return new RSAPublicEncrypt(key);
    }

    public RSAPrivateEncrypt privateEncrypt(String key) {
        return new RSAPrivateEncrypt(key);
    }

    public RSAPublicEncrypt publicEncrypt(byte[] key) {
        return new RSAPublicEncrypt(key);
    }

    public RSAPrivateEncrypt privateEncrypt(byte[] key) {
        return new RSAPrivateEncrypt(key);
    }

    public static RSAEncrypt get() {
        return RSAEncrypt.get(1024);
    }

    public static RSAEncrypt get(int keySize) {
        return new RSAEncrypt(keySize);
    }
}

